% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_version.R
\name{ChunkVersion}
\alias{ChunkVersion}
\alias{get_chunk_version_value}
\alias{get_chunk_version_data}
\alias{put_chunk_version_value}
\alias{put_chunk_version_data}
\title{Read and write chunk version data}
\usage{
get_chunk_version_value(x, z, dimension, db = default_db())

get_chunk_version_data(x, z, dimension, db = default_db())

put_chunk_version_value(value, x, z, dimension, db = default_db())

put_chunk_version_data(values, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{An integer}

\item{values}{A (named) vector of ChunkVersion values. If \code{x} is
missing, the names of \code{values} will be taken as the keys.}
}
\value{
\code{get_chunk_version_value()} returns a ChunkVersion data
value. \code{get_chunk_version_data()} returns a named vector of
ChunkVersion data values.
}
\description{
ChunkVersion data (tag 44) stores the chunk version number for a chunk.
}
\details{
\itemize{
\item \code{get_chunk_version_value()} and \code{get_chunk_version_data()} load
ChunkVersion data from \code{db}. \code{get_chunk_version_value()}
loads data for a single chunk, and \code{get_chunk_version_data()} loads
data for multiple chunks.
\item \code{put_chunk_version_value()} and \code{put_chunk_version_data()}
store ChunkVersion data into \code{db}.
}
}
\seealso{
ChunkVersion
}
