\name{bhl_gettitlebibTex}
\alias{bhl_gettitlebibTex}
\title{Return a citation for a title, using the BibTeX format.}
\usage{
bhl_gettitlebibTex(titleid = NULL, format = "json", output = "list",
  key = NULL, callopts = list())
}
\arguments{
  \item{titleid}{the identifier of an individual title
  (numeric)}

  \item{format}{either XML ('xml') or JSON ('json') format.
  If output='list', format is forced to equal 'json'}

  \item{output}{Return a list, raw json or xml, or parsed
  data (character).  Default: 'list'}

  \item{key}{your BHL API key, either enter, or loads from
  .Rprofile}

  \item{callopts}{Call options passed on to httr::GET.}
}
\description{
Return a citation for a title, using the BibTeX format.
}
\examples{
\dontrun{
bhl_gettitlebibTex(1726)
bhl_gettitlebibTex(1726, output='raw')
bhl_gettitlebibTex(1726, format='xml', output='raw')
bhl_gettitlebibTex(1726, format='xml', output='parsed')
}
}

