% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_mapping}
\alias{rba_reactome_mapping}
\title{Map External ID to Reactome Pathways/Reactions}
\usage{
rba_reactome_mapping(id, resource, map_to, species = "Homo sapiens", ...)
}
\arguments{
\item{id}{Molecule's external Identifier}

\item{resource}{What is the resource of your provided ID? see:
\href{https://reactome.org/content/schema/objects/ReferenceDatabase}{Reactome External
Identifiers}}

\item{map_to}{Either "pathways" or "reactions".}

\item{species}{Numeric or Character: NCBI Taxonomy identifier (Human
is 9606), species name (e.g. "Homo sapiens") or Reactome DbId (e.g
Homo sapiens is 48887). Refer to
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species}{Reactome
 Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
Data frame where each row is a pathway/reaction and columns are
  pertinent information.
}
\description{
By providing an external identifier from a given resource, you can retrieve
  a list of pathways/reactions that include your provided ID.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/mapping/{resource}/
 {identifier}/pathways"
 \cr "GET https://reactome.org/ContentService/data/mapping/{resource}/
 {identifier}/reactions"
}

\examples{
\donttest{
rba_reactome_mapping(id = "PTEN", resource =  "UniProt",
    map_to = "reactions", species = 9606)
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\concept{"Reactome Content Service - Mapping Related Queries"}
