% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_taxons_matrices}
\alias{rba_jaspar_taxons_matrices}
\title{List matrices available in JASPAR of a taxonomic group}
\usage{
rba_jaspar_taxons_matrices(
  tax_group,
  release = 2022,
  only_last_version = FALSE,
  search = NULL,
  order = NULL,
  page_size = 1000,
  page = 1,
  ...
)
}
\arguments{
\item{tax_group}{Character: Taxonomic group. Use
\code{\link{rba_jaspar_taxons}} to get a list of supported Taxonomic
groups.}

\item{release}{Numeric: (default = 2022) Which JASPAR database release
to use? Available options are: 2014, 2016, 2018, 2020, and 2022.}

\item{only_last_version}{Logical: (default = FALSE) If TRUE, only the
latest version of a matrix profile will be returned.}

\item{search}{Character: A search term.}

\item{order}{Character: A character string or a vector of character strings
of field names that will be used to order the results.
\cr Providing multiple field names is supported. You can also use prefix
"-" before a field name to indicate reverse ordering.}

\item{page_size}{Numeric: (default = 1000) This resource returns paginated
results. What is the maximum numbers of results that you want to retrieve
per a page? Accepted values are between 1 and 1000.}

\item{page}{Numeric: Which page of the results to retrieve? The accepted
values depend on the page size and number of results.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains a data frame with information of matrix
  profiles available for the taxonomic group.
}
\description{
JASPAR organizes matrix profiles from multiple species
  in six taxonomic groups. Using this function you can list all
  matrix profiles that are available in a JASPAR release from a
  taxonomic group.
}
\details{
The results are paginated. You can control the page's size number
  with the function's arguments. Also, you can use \code{\link{rba_pages}}
  to automatically iterate over multiple pages.
}
\section{Corresponding API Resources}{

 "GET "https://jaspar.genereg.net/api/v1/taxon/{tax_group}/"
}

\examples{
\donttest{
rba_jaspar_taxons_matrices(tax_group = "plants", page_size = 100)
}

}
\references{
\itemize{
  \item Jaime A Castro-Mondragon, Rafael Riudavets-Puig, Ieva
  Rauluseviciute, Roza Berhanu Lemma, Laura Turchi, Romain Blanc-Mathieu,
  Jeremy Lucas, Paul Boddie, Aziz Khan, Nicolás Manosalva Pérez, Oriol
  Fornes, Tiffany Y Leung, Alejandro Aguirre, Fayrouz Hammal, Daniel
  Schmelter, Damir Baranasic, Benoit Ballester, Albin Sandelin, Boris
  Lenhard, Klaas Vandepoele, Wyeth W Wasserman, François Parcy,
  Anthony Mathelier, JASPAR 2022: the 9th release of the open-access
  database of transcription factor binding profiles, Nucleic Acids
  Research, Volume 50, Issue D1, 7 January 2022, Pages D165–D173,
  https://doi.org/10.1093/nar/gkab1113
  \item
  \href{https://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.genereg.net/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
