% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_ortholog}
\alias{rba_panther_ortholog}
\title{Search PANTHER for Orthologs of Gene(s)}
\usage{
rba_panther_ortholog(
  genes,
  organism,
  type = "all",
  target_organisms = NULL,
  seq_pos = NULL,
  include_msa = NULL,
  ...
)
}
\arguments{
\item{genes}{Character vector of genes identifiers with maximum length of
10 or only one if seq_pos is supplied. Can be any of: Ensemble gene ID,
Ensemble protein ID, Ensemble transcript ID, Entrez gene ID, gene symbol,
NCBI GI, HGNC ID, International protein index ID, NCBI UniGene ID,
UniProt accession and/or UniProt ID.}

\item{organism}{(numeric) NCBI taxon ID of the organism of your supplied
genes. run \code{\link{rba_panther_info}} with argument
'what = "organisms"' to get a list of PANTHER's supported organisms.}

\item{type}{Ortholog types to return. either "all" (default) or "LDO" to
only return least diverged orthologs.}

\item{target_organisms}{(numeric) NCBI taxon ID(s) to filter the results.
run \code{\link{rba_panther_info}} with argument 'what = "organisms"' to
get a list of PANTHER's supported organisms.}

\item{seq_pos}{(Numeric) A position in the protein's sequence of the
supplied gene. should be in the range of the protein's length.}

\item{include_msa}{(Logical) Only if a sequence position is supplied,
should MSA (Multiple Sequence Alignment) information be included in the
results?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with Orthologs information.
}
\description{
Using this function you can search and retrieve orthologs of given gene(s),
  and optionally return the corresponding position in the target organisms'
  protein sequences.
}
\section{Corresponding API Resources}{

 "POST http://www.pantherdb.org/services/oai/pantherdb/ortholog/matchortho"
 \cr "POST http://www.pantherdb.org/services/oai/pantherdb/ortholog/homologpos"
}

\examples{
\donttest{
rba_panther_ortholog("CD40", organism = 9606, type = "LDO")
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{http://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
