% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_taxonomy.R
\name{rba_uniprot_taxonomy_lca}
\alias{rba_uniprot_taxonomy_lca}
\title{Get Lowest Common Ancestor (LCA) of Two Taxonomy Nodes}
\usage{
rba_uniprot_taxonomy_lca(ids, ...)
}
\arguments{
\item{ids}{(numeric) Numeric vector of
\href{https://www.uniprot.org/help/taxonomic_identifier}{NCBI taxonomic
identifiers}, with minimum length of two.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list with UniProt taxonomy information of your supplied taxonomy
  elements.
}
\description{
Use this function to retrieve lowest common ancestor (LCA) of two
 taxonomy nodes in
 \href{https://www.uniprot.org/help/taxonomy}{UniProt Taxonomy database}
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/ancestor/{ids}"
}

\examples{
\donttest{
rba_uniprot_taxonomy_lca(c(9606,10090,9823,7712))
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Taxonomy": 
\code{\link{rba_uniprot_taxonomy_lineage}()},
\code{\link{rba_uniprot_taxonomy_name}()},
\code{\link{rba_uniprot_taxonomy_path}()},
\code{\link{rba_uniprot_taxonomy_relationship}()},
\code{\link{rba_uniprot_taxonomy}()}
}
\concept{"UniProt - Taxonomy"}
