% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_coordinates.R
\name{rba_uniprot_coordinates_search}
\alias{rba_uniprot_coordinates_search}
\title{Search Genomic Coordinates of UniProt entries}
\usage{
rba_uniprot_coordinates_search(
  accession = NULL,
  chromosome = NULL,
  ensembl_id = NULL,
  gene = NULL,
  protein = NULL,
  taxid = NULL,
  location = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{chromosome}{chromosome name, such as "X", "Y", 1, 20, etc. You can
supply up to 20 values.}

\item{ensembl_id}{Ensembl Stable gene ID, transcript ID or translation ID.
You can supply up to 20 IDs.}

\item{gene}{\href{https://www.uniprot.org/help/gene_name}{UniProt gene
name(s)}. You can supply up to 20 gene names.}

\item{protein}{\href{https://www.uniprot.org/help/protein_names}{UniProt
protein name}}

\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{location}{Genome location range such as "58205437-58219305"}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List where each element corresponds to one UniProt entity returned
  by your search query. The element itself is a sub-list containing that
  protein's coordinates information.
}
\description{
Use this function to search genomic coordinates of UniProt entries.
  You may also refine your search with modifiers such as chromosome, taxon
  id etc. See "Arguments section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
  \cr For more information about how UniProt imports and calculates genomic
  coordinates data, see:
  \cr McGarvey, P. B., Nightingale, A., Luo, J., Huang, H., Martin, M. J.,
  Wu, C., & UniProt Consortium (2019). UniProt genomic mapping for
  deciphering functional effects of missense variants. Human mutation,
  40(6), 694–705. https://doi.org/10.1002/humu.23738
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/coordinates"
}

\examples{
\donttest{
rba_uniprot_coordinates_search(taxid = 9606, chromosome = "y")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Coordinates": 
\code{\link{rba_uniprot_coordinates}()},
\code{\link{rba_uniprot_coordinates_location}()},
\code{\link{rba_uniprot_coordinates_sequence}()}
}
\concept{"UniProt - Coordinates"}
