% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdiv_ord_table.r
\name{bdiv_ord_table}
\alias{bdiv_ord_table}
\title{Calculate PCoA and other ordinations, including taxa biplots and statistics.}
\usage{
bdiv_ord_table(
  biom,
  bdiv = "Bray-Curtis",
  ord = "PCoA",
  weighted = TRUE,
  md = NULL,
  k = 2,
  stat.by = NULL,
  split.by = NULL,
  tree = NULL,
  test = "adonis2",
  seed = 0,
  permutations = 999,
  rank = NULL,
  taxa = 6,
  p.top = Inf,
  p.adj = "fdr",
  unc = "singly",
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{bdiv}{Beta diversity distance algorithm(s) to use. Options are:
\code{"Bray-Curtis"}, \code{"Manhattan"}, \code{"Euclidean"},
\code{"Jaccard"}, and \code{"UniFrac"}. For \code{"UniFrac"}, a
phylogenetic tree must be present in \code{biom} or explicitly
provided via \verb{tree=}. Multiple/abbreviated values allowed.
Default: \code{"Bray-Curtis"}}

\item{ord}{Method for reducing dimensionality. Options are:
\describe{
\item{\code{"PCoA"} - }{ Principal coordinate analysis; \code{\link[ape:pcoa]{ape::pcoa()}}. }
\item{\code{"UMAP"} - }{ Uniform manifold approximation and projection; \code{\link[uwot:umap]{uwot::umap()}}. }
\item{\code{"NMDS"} - }{ Nonmetric multidimensional scaling; \code{\link[vegan:metaMDS]{vegan::metaMDS()}}. }
\item{\code{"tSNE"} - }{ t-distributed stochastic neighbor embedding; \code{\link[tsne:tsne]{tsne::tsne()}}. }
}
Multiple/abbreviated values allowed. Default: \code{"PCoA"}}

\item{weighted}{Take relative abundances into account. When
\code{weighted=FALSE}, only presence/absence is considered.
Multiple values allowed. Default: \code{TRUE}}

\item{md}{Dataset field(s) to include in the output data frame, or \code{'.all'}
to include all metadata fields. Default: \code{'.all'}}

\item{k}{Number of ordination dimensions to return. Either \code{2L} or
\code{3L}. Default: \code{2L}}

\item{stat.by}{The categorical or numeric metadata field over which
statistics should be calculated. Required.}

\item{split.by}{Dataset field(s) that the data should be split by prior to
any calculations. Must be categorical. Default: \code{NULL}}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Only required when
computing UniFrac distances. Default: \code{biom$tree}}

\item{test}{Permutational test for accessing significance. Options are:
\describe{
\item{\code{"adonis2"} - }{ Permutational MANOVA; \code{\link[vegan:adonis]{vegan::adonis2()}}. }
\item{\code{"mrpp"} - }{ Multiple response permutation procedure; \code{\link[vegan:mrpp]{vegan::mrpp()}}. }
\item{\code{"none"} - }{ Don't run any statistics. }
}
Abbreviations are allowed. Default: \code{"adonis2"}}

\item{seed}{Random seed for permutations. Must be a non-negative integer.
Default: \code{0}}

\item{permutations}{Number of random permutations to use.
Default: \code{999}}

\item{rank}{What rank(s) of taxa to compute biplot coordinates and
statistics for, or \code{NULL} to disable. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{NULL}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{p.top}{Only display taxa with the most significant differences in
abundance. If \code{p.top} is >= 1, then the \code{p.top} most
significant taxa are displayed. If \code{p.top} is less than one, all
taxa with an adjusted p-value <= \code{p.top} are displayed.
Recommended to be used in combination with the \code{taxa} parameter
to set a lower bound on the mean abundance of considered taxa.
Default: \code{Inf}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{...}{Additional arguments to pass on to \code{\link[uwot:umap]{uwot::umap()}},
\code{\link[ape:pcoa]{ape::pcoa()}}, \code{\link[vegan:metaMDS]{vegan::metaMDS()}}, or \code{\link[tsne:tsne]{tsne::tsne()}}.}
}
\value{
A data.frame with columns \code{.sample}, \code{.weighted},
\code{.bdiv}, \code{.ord}, \code{.x}, \code{.y}, and (optionally)
\code{.z}. Any columns given by \code{md}, \code{split.by}, and
\code{stat.by} are included as well.
If \code{stat.by} is given, then \code{$stats} and
\code{$stats$code)} are set.
If \code{rank} is given, then \code{$taxa_coords},
\code{$taxa_stats}, and \code{$taxa_stats$code} are set.
}
\description{
The biplot parameters (\code{taxa}, \code{unc}, \code{p.top}, and
\code{p.adj}) only only have an effect when \code{rank} is not \code{NULL}.
}
\examples{
    library(rbiom)
    
    ord <- bdiv_ord_table(hmp50, "bray", "pcoa", stat.by="Body Site", rank="g")
    head(ord)
    
    ord$stats
    
    ord$taxa_stats
    
    
}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()},
\code{\link{distmat_stats}()}

Other ordination: 
\code{\link{bdiv_ord_plot}()},
\code{\link{distmat_ord_table}()}
}
\concept{beta_diversity}
\concept{ordination}
