% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adiv_table.r
\name{adiv_table}
\alias{adiv_table}
\title{Calculate the alpha diversity of each sample.}
\usage{
adiv_table(biom, adiv = "Shannon", md = ".all", transform = "none")
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{adiv}{Alpha diversity metric(s) to use. Options are: \code{"OTUs"},
\code{"Shannon"}, \code{"Chao1"}, \code{"Simpson"}, and/or
\code{"InvSimpson"}. Set \code{adiv=".all"} to use all metrics.
Multiple/abbreviated values allowed.
Default: \code{"Shannon"}}

\item{md}{Dataset field(s) to include in the output data frame, or \code{'.all'}
to include all metadata fields. Default: \code{'.all'}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}
}
\value{
A data frame of alpha diversity values.
Each combination of sample/depth/\code{adiv} has its own row.
Column names are \bold{.sample}, \bold{.depth}, \bold{.adiv},
and \bold{.diversity}, followed by any metadata fields requested by
\code{md}.
}
\description{
Calculate the alpha diversity of each sample.
}
\examples{
    library(rbiom) 
    
    # Subset to 10 samples.
    biom <- slice(hmp50, 1:10)
    adiv_table(biom)
    
    biom <- rarefy(biom)
    adiv_table(biom, adiv = ".all", md = NULL)
}
\seealso{
Other alpha_diversity: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{adiv_stats}()}
}
\concept{alpha_diversity}
