% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.r
\name{taxa_clusters}
\alias{taxa_clusters}
\title{Define sample kmeans clusters from taxa abundances.}
\usage{
taxa_clusters(biom, rank = ".otu", k = 5, ...)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rank}{Which taxa rank to use. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{.otu}.}

\item{k}{Number of clusters. Default: \code{5L}}

\item{...}{Passed on to \code{stats::kmeans()}.}
}
\value{
A numeric factor assigning samples to clusters.
}
\description{
Define sample kmeans clusters from taxa abundances.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    biom$metadata$otu_cluster <- taxa_clusters(biom)
    
    pull(biom, 'otu_cluster')[1:10]
    
    bdiv_ord_plot(biom, layers = "p", stat.by = "otu_cluster")
}
\seealso{
Other taxa_abundance: 
\code{\link{sample_sums}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()},
\code{\link{taxa_stats}()},
\code{\link{taxa_sums}()},
\code{\link{taxa_table}()}

Other clustering: 
\code{\link{bdiv_clusters}()}
}
\concept{clustering}
\concept{taxa_abundance}
