% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Generate data}
\usage{
simulate_data(pars_c, pars_t, post_ice1_traj, strategies = getStrategies())
}
\arguments{
\item{pars_c}{A \code{simul_pars} object as generated by \code{\link[=set_simul_pars]{set_simul_pars()}}. It specifies
the simulation parameters of the control arm.}

\item{pars_t}{A \code{simul_pars} object as generated by \code{\link[=set_simul_pars]{set_simul_pars()}}. It specifies
the simulation parameters of the treatment arm.}

\item{post_ice1_traj}{A string which specifies how observed outcomes occurring after
ICE1 are simulated.
Must target a function included in \code{strategies}. Possible choices are: Missing At
Random \code{"MAR"}, Jump to Reference \code{"JR"},
Copy Reference \code{"CR"}, Copy Increments in Reference \code{"CIR"}, Last Mean Carried
Forward \code{"LMCF"}. User-defined strategies
could also be added. See \code{\link[=getStrategies]{getStrategies()}} for details.}

\item{strategies}{A named list of functions. Default equal to \code{\link[=getStrategies]{getStrategies()}}.
See \code{\link[=getStrategies]{getStrategies()}} for details.}
}
\value{
A \code{data.frame} containing the simulated data. It includes the following variables:
\itemize{
\item \code{id}: Factor variable that specifies the id of each subject.
\item \code{visit}: Factor variable that specifies the visit of each assessment. Visit \code{0} denotes
the baseline visit.
\item \code{group}: Factor variable that specifies which treatment group each subject belongs to.
\item \code{outcome_bl}: Numeric variable that specifies the baseline outcome.
\item \code{outcome_noICE}: Numeric variable that specifies the longitudinal outcome assuming
no ICEs.
\item \code{ind_ice1}: Binary variable that takes value \code{1} if the corresponding visit is
affected by ICE1 and \code{0} otherwise.
\item \code{dropout_ice1}: Binary variable that takes value \code{1} if the corresponding visit is
affected by the drop-out following ICE1 and \code{0} otherwise.
\item \code{ind_ice2}: Binary variable that takes value \code{1} if the corresponding visit is affected
by ICE2.
\item \code{outcome}: Numeric variable that specifies the longitudinal outcome including ICE1, ICE2
and the intermittent missing values.
}
}
\description{
Generate data for a two-arms clinical trial with longitudinal continuous
outcome and two intercurrent events (ICEs).
ICE1 may be thought of as a discontinuation from study treatment due to study drug or
condition related (SDCR) reasons.
ICE2 may be thought of as discontinuation from study treatment due to uninformative
study drop-out, i.e. due to not study drug or
condition related (NSDRC) reasons and outcome data after ICE2 is always missing.
}
\details{
The data generation works as follows:
\itemize{
\item Generate outcome data for all visits (including baseline) from a multivariate
normal distribution with parameters \code{pars_c$mu} and \code{pars_c$sigma}
for the control arm and parameters \code{pars_t$mu} and \code{pars_t$sigma} for the treatment
arm, respectively.
Note that for a randomized trial, outcomes have the same distribution at baseline
in both treatment groups, i.e. one should set
\code{pars_c$mu[1]=pars_t$mu[1]} and \code{pars_c$sigma[1,1]=pars_t$sigma[1,1]}.
\item Simulate whether ICE1 (study treatment discontinuation due to SDCR reasons) occurs
after each visit according to parameters \code{pars_c$prob_ice1} and \code{pars_c$or_outcome_ice1}
for the control arm and \code{pars_t$prob_ice1} and \code{pars_t$or_outcome_ice1} for the
treatment arm, respectively.
\item Simulate drop-out following ICE1 according to \code{pars_c$prob_post_ice1_dropout} and
\code{pars_t$prob_post_ice1_dropout}.
\item Simulate an additional uninformative study drop-out with probabilities \code{pars_c$prob_dropout}
and \code{pars_t$prob_dropout} at each visit.
The simulated time of drop-out is the subject's first visit which is affected by
drop-out and data from this visit and all subsequent visits are consequently set to missing.
In addition, in case the subject is still on treatment at the subject's (first)
visit affected by drop-out (i.e. if this occurs prior to ICE1),
then dropout also triggers discontinuation of study drug and a corresponding ICE2
(study treatment discontinuation due to NSDCR reasons) is generated.
\item Adjust trajectories after ICE according to the given assumption expressed with
the \code{post_ice1_traj} argument. Note that only post-ICE1 outcomes in the intervention arm can be
adjusted. Post-ICE1 outcomes from the control arm  are not adjusted.
\item Simulate additional intermittent missing outcome data as per arguments \code{pars_c$prob_miss}
and \code{pars_t$prob_miss}.
}

The probability of the ICE after each visit is modeled according to the following
logistic regression model:
\code{~ 1 + I(visit == 0) + ... + I(visit == n_visits-1) + I((x-alpha))} where:
\itemize{
\item \code{n_visits} is the number of visits (including baseline).
\item \code{alpha} is the baseline outcome mean.
The term \code{I((x-alpha))} specifies the dependency of the probability of the ICE on
the current outcome value.
The corresponding regression coefficients of the logistic model are defined as follows:
The intercept is set to 0, the coefficients corresponding to discontinuation after
each visit for a subject with outcome equal to
the mean at baseline are set according to parameters \code{pars_c$prob_ice1} (\code{pars_t$prob_ice1}),
and the regression coefficient associated with the covariate \code{I((x-alpha))} is set
to \code{log(pars_c$or_outcome_ice1)} (\code{log(pars_t$or_outcome_ice1)}).
}

Please note that the baseline outcome cannot be missing nor be affected by any ICEs.
}
