% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_axis.R
\name{y_axis}
\alias{y_axis}
\title{Customize x axis of a Bokeh figure}
\usage{
y_axis(fig, label, position = "left", log = FALSE, grid = TRUE,
  desired_num_ticks = NULL, num_minor_ticks = 5, visible = TRUE,
  number_formatter = c("basic", "numeral", "printf"), power_limit_high = 5,
  power_limit_low = -3, precision = NULL, use_scientific = TRUE,
  format = NULL)
}
\arguments{
\item{fig}{figure to modify}

\item{label}{axis label}

\item{position}{where to place the axis (either "left" or "right")}

\item{log}{logical or integer - if TRUE, a log axis with base 10 is used - if an integer, a log axis with base of that integer will be used}

\item{grid}{logical - should a reference grid be shown for this axis?}

\item{desired_num_ticks}{desired target number of major tick positions to generate across the plot range}

\item{num_minor_ticks}{number of minor ticks}

\item{visible}{should axis be shown?}

\item{number_formatter}{Bokeh numeric tick label formatter
(\href{http://bokeh.pydata.org/en/latest/docs/reference/models.html#bokeh.models.formatters.BasicTickFormatter}{"basic"},
\href{http://bokeh.pydata.org/en/latest/docs/reference/models.html#bokeh.models.formatters.NumeralTickFormatter}{"numeral"},
or \href{http://bokeh.pydata.org/en/latest/docs/reference/models.html#bokeh.models.formatters.PrintfTickFormatter}{"printf"});
ignored if \code{log} is TRUE}

\item{power_limit_high}{(int) Limit the use of scientific notation to when log(x) >= value. Only applicable when \code{number_formatter} is "basic".}

\item{power_limit_low}{(int) Limit the use of scientific notation to when log(x) <= value. Only applicable when \code{number_formatter} is "basic".}

\item{precision}{(int) How many digits of precision to display in tick labels. Automatically determined if not specified. Only applicable when \code{number_formatter} is "basic".}

\item{use_scientific}{(logical) Whether to ever display scientific notation. If True, then when to use scientific notation is controlled by \code{power_limit_low} and \code{power_limit_high}. Only applicable when \code{number_formatter} is "basic".}

\item{format}{Specification of format options.  Specification depends on the value of \code{number_formatter} - see "details" below.}
}
\description{
Customize x axis of a Bokeh figure
}
\examples{
\dontrun{
figure() \%>\%
  ly_points(rexp(1000), rexp(1000)) \%>\%
  x_axis(label = "x", log = TRUE) \%>\%
  y_axis(label = "y", log = TRUE)

figure() \%>\%
  ly_points(2^(1:10)) \%>\%
  y_axis(log = 2)

# disable scientific tick labels
figure() \%>\%
  ly_points(rnorm(10), rnorm(10) / 1000) \%>\%
  y_axis(use_scientific = FALSE)

# specify datetime tick labels
# the appropriate datetime units are automatically chosen
big_range <- seq(as.Date("2012-01-01"), as.Date("2012-12-31"), by="days")
small_range <- seq(as.Date("2012-01-01"),as.Date("2012-02-01"), by="days")

figure() \%>\%
  ly_lines(big_range, rnorm(366)) \%>\%
  x_axis(label = "Date", format = list(months="\%b-\%Y", days="\%d"))

figure() \%>\%
  ly_lines(small_range, rnorm(32)) \%>\%
  x_axis(label = "Date", format = list(months="\%b-\%Y", days="\%d"))

# specify numeric tick labels
figure() \%>\%
  ly_points(rnorm(10), rnorm(10) * 10000) \%>\%
  y_axis(number_formatter = "numeral", format = "0,000")

figure() \%>\%
  ly_points(rnorm(10), rnorm(10) * 100) \%>\%
  y_axis(number_formatter = "printf", format = "\%0.1f\%\%")
}
}
\seealso{
Other axes: \code{\link{x_axis}}
}

