% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_glyphs.R
\name{ly_annular_wedge}
\alias{ly_annular_wedge}
\title{Add an "annular_wedge" layer to a Bokeh figure}
\usage{
ly_annular_wedge(fig, x, y = NULL, data = figure_data(fig),
  inner_radius = 0.1, outer_radius = 0.3, start_angle = 0, end_angle = 2
  * pi, direction = "anticlock", color = NULL, alpha = 1, hover = NULL,
  url = NULL, legend = NULL, lname = NULL, lgroup = NULL,
  visible = TRUE, ...)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{values or field name of center x coordinates}

\item{y}{values or field name of center y coordinates}

\item{data}{an optional data frame, providing the source for inputs x, y, and other glyph properties}

\item{inner_radius}{values or field name of inner radii}

\item{outer_radius}{values or field name of outer radii}

\item{start_angle}{the angles to start the annular wedges, in radians, as measured from the horizontal}

\item{end_angle}{the angles to end the annular wedges, in radians, as measured from the horizontal}

\item{direction}{direction to turn between starting and ending angles ("anticlock", "clock")}

\item{color}{color for the glyph - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' - for glyphs with both fill and line properties, see "Handling color" below}

\item{alpha}{the alpha transparency of the glyph between 0 (transparent) and 1 (opaque) - if glyph has both fill and color properties, see "Handling alpha" below}

\item{hover}{a data frame of variables to be displayed when hovering over the glyph or a vector of variable names that can be found and extracted from the \code{data} argument}

\item{url}{a string of URLs or a single string that references a variable name (via @var_name) that can be found and extracted from the \code{data} argument}

\item{legend}{either a logical specifying not to plot a legend for this layer (FALSE) or a string indicating the name of the legend entry for this layer (note that when mapping plot attributes to variables in \code{data}, a legend is automatically created and does not need to be specified - see "Mapped plot attributes and legends" below)}

\item{lname}{layer name}

\item{lgroup}{layer group}

\item{visible}{should the layer be visible?}

\item{\ldots}{additional parameters for fine control over fill and line properties (see "Additional parameters" below)}
}
\description{
Add an "annular_wedge" layer to a Bokeh figure
}
\section{Handling color}{
 The \code{color} parameter is a high-level plot attribute that provides default behavior for coloring glyphs.
\itemize{
  \item When using a glyph that only has line properties, this will be the color of the line.
  \item When using a glyph that has has line and fill properties, this will be the color of the line and the fill, with the alpha level of the fill reduced by 50\%.
  \item If full control over fill and line color is desired, the \code{fill_color} and \code{line_color} attributes can be specified explicitly and will override \code{color}.
}
When color is \code{NULL} and \code{fill_color} or \code{line_color} are not specified, the color will be chosen from the theme.
}

\section{Handling alpha}{
 The \code{alpha} is a high-level plot attribute that sets the transparency of the glyph being plotted.
\itemize{
  \item When using a glyph that only has line properties, this will be the alpha of the line.
  \item When using a glyph that has has line and fill properties, this will be the alpha of the line and the alpha of the fill will be set to 50\% of this value.
  \item Individual fill and line alpha can be specified with \code{fill_alpha} and \code{line_alpha} and will override \code{alpha}.
}
}

\section{Mapped plot attributes and legends}{
 When specifying an input data frame for a layer through the \code{data} argument, columns of \code{data} can be used to specify various plot attributes such as \code{color}, etc. For example, with \code{ly_points(..., data = iris, color = Species)}, the \code{Species} variable is used to determine how to color the points.  Here, \code{Species} is "mapped" to the \code{color} attribute.  Both continuous and categorical variables can be mapped.  In the case of continuous variables, the range is cut into slices and attributes are applied to each interval.  The mapping from the values of the variable to the actual plot attributes is determined based on the theme.
}

\section{Additional parameters}{

\tabular{ll}{
  \code{fill_color} \tab color to use to fill the glyph with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' \cr
  \code{fill_alpha} \tab transparency value between 0 (transparent) and 1 (opaque) \cr
  \code{line_color} \tab color to use to stroke lines with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo' \cr
  \code{line_width} \tab stroke width in units of pixels \cr
  \code{line_alpha} \tab transparency value between 0 (transparent) and 1 (opaque) \cr
  \code{line_join} \tab how path segments should be joined together 'miter' 'round' 'bevel' \cr
  \code{line_cap} \tab how path segments should be terminated 'butt' 'round' 'square' \cr
  \code{line_dash} \tab array of integer pixel distances that describe the on-off pattern of dashing to use \cr
  \code{line_dash_offset} \tab the distance in pixels into the line_dash that the pattern should start from
 }
}
\examples{
rescale <- function(x)
  (x - min(x)) / diff(range(x))
figure() \%>\%
  ly_annular_wedge(Sepal.Length, Sepal.Width, data = iris,
    end_angle = rescale(Petal.Length) * 2 * pi, color = Species,
    inner_radius = 0.1, outer_radius = 0.15, alpha = 0.5,
    hover = Species)
}
\seealso{
Other layer functions: \code{\link{ly_abline}},
  \code{\link{ly_annulus}}, \code{\link{ly_arc}},
  \code{\link{ly_bar}}, \code{\link{ly_bezier}},
  \code{\link{ly_boxplot}}, \code{\link{ly_contour}},
  \code{\link{ly_crect}}, \code{\link{ly_curve}},
  \code{\link{ly_density}}, \code{\link{ly_hist}},
  \code{\link{ly_image_url}}, \code{\link{ly_image}},
  \code{\link{ly_lines}}, \code{\link{ly_map}},
  \code{\link{ly_multi_line}}, \code{\link{ly_oval}},
  \code{\link{ly_patch}}, \code{\link{ly_points}},
  \code{\link{ly_polygons}}, \code{\link{ly_quadratic}},
  \code{\link{ly_quantile}}, \code{\link{ly_ray}},
  \code{\link{ly_rect}}, \code{\link{ly_segments}},
  \code{\link{ly_text}}, \code{\link{ly_wedge}}
}

