% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_naive_bayes.R
\name{w_naive_bayes}
\alias{w_naive_bayes}
\title{Naive Bayes algorithm with case weights}
\usage{
w_naive_bayes(x_train, y_train, w = NULL)
}
\arguments{
\item{x_train}{features.}

\item{y_train}{a factor class variable.}

\item{w}{a vector of case weights.}
}
\value{
a w_naive_bayes object with below components.
 \item{n_train}{Number of cases in the input dataset.}
 \item{p}{Number of features.}
 \item{x_classes}{A list of datasets, which are \code{x_train} separated
 for each class.}
 \item{n_classes}{Number of cases for each class in input dataset.}
 \item{k_classes}{Number of classes in class variable.}
 \item{priors}{Prior probabilities.}
 \item{class_names}{Names of classes in class variable.}
 \item{means}{Weighted mean estimations for each variable.}
 \item{stds}{Weighted standart deviation estimations for each variable.}
}
\description{
Function for Naive Bayes algorithm classification.
}
\details{
It uses Gaussian densities with case weights and allows
multiclass classification.
}
\examples{

x <- iris[,1:4]
y <- iris[,5]

# Without weights
m <- w_naive_bayes(x_train = x, y_train = y)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

# Using weights
weights <- ifelse(y == "setosa" | y == "versicolor", 1, 0.01)

m <- w_naive_bayes(x_train = x, y_train = y, w = weights)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

# Using weights example 2
weights <- ifelse(y == "setosa" | y == "virginica", 1, 0.01)

m <- w_naive_bayes(x_train = x, y_train = y, w = weights)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

}
