% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_feature.R
\name{extract_feature}
\alias{extract_feature}
\title{Extract feature}
\usage{
extract_feature(r, segmentation, fun = mean, return_raster = TRUE)
}
\arguments{
\item{r}{\linkS4class{RasterLayer}. Single layer raster.}

\item{segmentation}{\linkS4class{RasterLayer}. The segmentation of \code{r}.}

\item{fun}{\code{function} that takes a vector as input and returns a
one-length numeric or logical vector as output (e.g. mean).}

\item{return_raster}{Logical vector of length one.}
}
\value{
If \code{return_raster} is set to \code{TRUE}, then an object of
  class \linkS4class{RasterLayer} with the same pixel dimensions than
  \code{r} will be returned. Otherwise, the return is a numeric vector of
  length equal to the number of segments found in \code{segmentation}.
}
\description{
Extract features from raster images.
}
\details{
Given a single layer raster, a segmentation, and a function,
\code{extract_features} will returns a numeric vector or a
\linkS4class{RasterLayer} depending on whether the parameter
\code{return_raster} is \code{TRUE} or \code{FALSE}. For the first case, each
pixel of each segment will adopt the respective extracted feature value. For
the second case, the return will be the extracted feature as a vector of
length equal to the total number of segments. Each extracted feature value
will be obtained by processing all pixels that belong to a segment with the
provided function.
}
\examples{
\dontrun{
r <- read_caim()
z <- zenith_image(ncol(r),lens("Nikon_FCE9"))
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 10)
print(extract_feature(r$Blue, g, return_raster = FALSE))
plot(extract_feature(r$Blue, g, return_raster = TRUE))
}
}
\seealso{
Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
