% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_caim.R
\name{crop_caim}
\alias{crop_caim}
\title{Crop a canopy image from a file}
\usage{
crop_caim(r, upper_left = NULL, width = NULL, height = NULL)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}}

\item{upper_left}{An integer vector of length two. The pixels coordinates of
the upper left corner of a region of interest (ROI). These coordinates
should be in the raster coordinates system. This system works like a
spreadsheet, i.e, when going down through the vertical axis, the \emph{row}
number increases (\strong{IMPORTANT}: column and row must be provided instead of
row and column, as is the norm for objects from the class \emph{data.frame} and
others alike)}

\item{width, height}{An integer vector of length one. The size of the boxy ROI
whose upper left corner is the \code{upper_left} argument.}
}
\value{
\linkS4class{SpatRaster}
}
\description{
Function that complements \code{\link[=read_caim]{read_caim()}} and \code{\link[=read_caim_raw]{read_caim_raw()}}
}
\examples{
caim <- read_caim()
ncell(caim)
caim <- crop_caim(caim, c(231,334), 15, 10)
ncell(caim)
}
