% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{binPrep}
\alias{binPrep}
\title{Binning function of radiocarbon dates.}
\usage{
binPrep(sites, ages, h)
}
\arguments{
\item{sites}{a vector of character strings (or number to coerce to character) of all sites or site phases}

\item{ages}{a vector of uncalibrated conventional radiocarbon ages or a \code{CalDates} class object obtained using the \code{\link{calibrate}} function.}

\item{h}{a single numeric value passed to \code{\link{hclust}} control degree of grouping of similar ages in a phase site.}
}
\value{
A vector of character strings with the same length of the object supplied for the argument \code{ages} identifying intra-site or intra-phase grouping, for use with \code{\link{spd}}
}
\description{
Prepare a set of bins for controlling the aggregation of radiocarbon dates
known to be from the same phase of same archaeological site (for use with \code{\link{spd}}). Used in cases where there is a concern that unusually high levels of sampling for radiocarbon at a given site or in a given site phase will impede comparison between sites or phases.
}
\details{
If \code{ages} is a \code{CalDates} class object, median dates are used for the clustering.
}
\seealso{
\code{\link{spd}} for generating SPD; \code{\link{binsense}} for sensitivity analysis pertaining the choice of the parameter \code{h}.
}
