/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.io.JCPFileFilter;
import org.openscience.cdk.applications.jchempaint.io.JCPFileView;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.CMLReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.INChIReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.tools.HydrogenAdder;

public class OpenAction
extends JCPAction {
    private static final long serialVersionUID = 1030940425527065876L;
    private FileFilter currentFilter = null;
    static /* synthetic */ Class class$org$openscience$cdk$interfaces$IChemFile;
    static /* synthetic */ Class class$org$openscience$cdk$ChemModel;

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.jcpPanel.getCurrentWorkDirectory());
        JCPFileFilter.addChoosableFileFilters(chooser);
        if (this.jcpPanel.getCurrentOpenFileFilter() != null) {
            chooser.setFileFilter(this.jcpPanel.getCurrentOpenFileFilter());
        }
        if (this.jcpPanel.getLastOpenedFile() != null) {
            chooser.setSelectedFile(this.jcpPanel.getLastOpenedFile());
        }
        if (this.currentFilter != null) {
            chooser.setFileFilter(this.currentFilter);
        }
        chooser.setFileView(new JCPFileView());
        int returnVal = chooser.showOpenDialog(this.jcpPanel);
        String type = null;
        IChemObjectReader cor = null;
        this.currentFilter = chooser.getFileFilter();
        if (returnVal == 0) {
            this.jcpPanel.setCurrentWorkDirectory(chooser.getCurrentDirectory());
            this.jcpPanel.setCurrentOpenFileFilter(chooser.getFileFilter());
            File inFile = chooser.getSelectedFile();
            this.jcpPanel.setLastOpenedFile(inFile);
            try {
                cor = this.jcpPanel.getChemObjectReader(new FileReader(inFile));
            }
            catch (IOException ioExc) {
                logger.warn((Object)"IOException while determining file format.");
                logger.debug((Object)ioExc);
            }
            catch (Exception exc) {
                logger.warn((Object)"Exception while determining file format.");
                logger.debug((Object)exc);
            }
            if (cor == null) {
                try {
                    FileInputStream reader = new FileInputStream(inFile);
                    FileFilter ff = chooser.getFileFilter();
                    type = ff instanceof JCPFileFilter ? ((JCPFileFilter)ff).getType() : "unknown";
                    if (type.equals("cml") || type.equals("xml")) {
                        cor = new CMLReader((InputStream)reader);
                    } else if (type.equals("sdf")) {
                        cor = new MDLReader((InputStream)reader);
                    } else if (type.equals("mol")) {
                        cor = new MDLReader((InputStream)reader);
                    } else if (type.equals("txt")) {
                        cor = new INChIReader((InputStream)reader);
                    }
                }
                catch (FileNotFoundException exception) {
                    logger.warn((Object)"File cannot be found.");
                    logger.debug((Object)exception);
                }
            }
            if (cor == null) {
                JOptionPane.showMessageDialog(this.jcpPanel, "Could not determine file format.");
                return;
            }
            String error = null;
            ChemModel chemModel = null;
            IChemFile chemFile = null;
            if (cor.accepts(class$org$openscience$cdk$interfaces$IChemFile == null ? (class$org$openscience$cdk$interfaces$IChemFile = OpenAction.class$("org.openscience.cdk.interfaces.IChemFile")) : class$org$openscience$cdk$interfaces$IChemFile)) {
                try {
                    chemFile = (IChemFile)cor.read((IChemObject)new ChemFile());
                    if (chemFile != null) {
                        this.jcpPanel.processChemFile(chemFile);
                        if (this.jcpPanel.getJChemPaintModel().getControllerModel().getAutoUpdateImplicitHydrogens()) {
                            HydrogenAdder hydrogenAdder = new HydrogenAdder("org.openscience.cdk.tools.ValencyChecker");
                            Iterator mols = chemFile.getChemSequence(0).getChemModel(0).getMoleculeSet().molecules();
                            while (mols.hasNext()) {
                                IMolecule molecule = (IMolecule)mols.next();
                                if (molecule == null) continue;
                                try {
                                    hydrogenAdder.addImplicitHydrogensToSatisfyValency((IAtomContainer)molecule);
                                }
                                catch (Exception ex) {}
                            }
                        }
                        this.jcpPanel.lastUsedJCPP.getJChemPaintModel().setTitle(inFile.getName());
                        this.jcpPanel.lastUsedJCPP.setIsAlreadyAFile(inFile);
                        if (!this.jcpPanel.isEmbedded()) {
                            ((JFrame)this.jcpPanel.lastUsedJCPP.getParent().getParent().getParent().getParent()).setTitle(inFile.getName());
                        }
                        return;
                    }
                    logger.warn((Object)"The object chemFile was empty unexpectedly!");
                }
                catch (Exception exception) {
                    error = "Error while reading file: " + exception.getMessage();
                    exception.printStackTrace();
                    logger.warn((Object)error);
                    logger.debug((Object)exception);
                }
            }
            if (error != null) {
                JOptionPane.showMessageDialog(this.jcpPanel, error);
                return;
            }
            if (cor.accepts(class$org$openscience$cdk$ChemModel == null ? (class$org$openscience$cdk$ChemModel = OpenAction.class$("org.openscience.cdk.ChemModel")) : class$org$openscience$cdk$ChemModel)) {
                try {
                    chemModel = (ChemModel)cor.read((IChemObject)new ChemModel());
                    if (chemModel != null) {
                        this.jcpPanel.processChemModel((IChemModel)chemModel);
                        if (this.jcpPanel.getJChemPaintModel().getControllerModel().getAutoUpdateImplicitHydrogens()) {
                            HydrogenAdder hydrogenAdder = new HydrogenAdder("org.openscience.cdk.tools.ValencyChecker");
                            Iterator mols = chemModel.getMoleculeSet().molecules();
                            while (mols.hasNext()) {
                                IMolecule molecule = (IMolecule)mols.next();
                                if (molecule == null) continue;
                                try {
                                    hydrogenAdder.addImplicitHydrogensToSatisfyValency((IAtomContainer)molecule);
                                }
                                catch (Exception ex) {}
                            }
                        }
                        this.jcpPanel.lastUsedJCPP.getJChemPaintModel().setTitle(inFile.getName());
                        this.jcpPanel.lastUsedJCPP.setIsAlreadyAFile(inFile);
                        ((JFrame)this.jcpPanel.lastUsedJCPP.getParent().getParent().getParent().getParent()).setTitle(inFile.getName());
                        return;
                    }
                    logger.warn((Object)"The object chemModel was empty unexpectedly!");
                    error = null;
                }
                catch (Exception exception) {
                    error = "Error while reading file: " + exception.getMessage();
                    exception.printStackTrace();
                    logger.error((Object)error);
                    logger.debug((Object)exception);
                }
            }
            if (error != null) {
                JOptionPane.showMessageDialog(this.jcpPanel, error);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

