/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openscience.cdk.Atom;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.swing.FieldTablePanel;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.validate.ProblemMarker;
import org.openscience.cdk.validate.ValidationReport;
import org.openscience.cdk.validate.ValidationTest;

public class ValidateFrame
extends JFrame {
    private static final long serialVersionUID = -8073655554072154298L;
    private Renderer2DModel rendererModel;
    private JPanel errorTreePanel;
    private JPanel warningTreePanel;
    private JPanel cdkErrorTreePanel;
    private JTextArea detailText;

    public ValidateFrame(JChemPaintPanel jcpp) {
        super("Validation Results");
        this.rendererModel = jcpp.getJChemPaintModel().getRendererModel();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OKAction());
        southPanel.add(okButton);
        FieldTablePanel detailPanel = new FieldTablePanel();
        this.detailText = new JTextArea(2, 40);
        this.detailText.setBackground(Color.white);
        this.detailText.setWrapStyleWord(true);
        this.detailText.setText("");
        detailPanel.addArea("Details", (JComponent)this.detailText);
        detailPanel.validate();
        JTabbedPane tabbedPane = new JTabbedPane();
        this.errorTreePanel = new JPanel();
        this.addJTree(new JTree(new DefaultMutableTreeNode("not validated")), this.errorTreePanel);
        this.warningTreePanel = new JPanel();
        this.addJTree(new JTree(new DefaultMutableTreeNode("not validated")), this.warningTreePanel);
        this.cdkErrorTreePanel = new JPanel();
        this.addJTree(new JTree(new DefaultMutableTreeNode("not validated")), this.cdkErrorTreePanel);
        tabbedPane.add("Errors", this.errorTreePanel);
        tabbedPane.add("Warnings", this.warningTreePanel);
        tabbedPane.add("CDK Errors", this.cdkErrorTreePanel);
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)detailPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.validate();
    }

    private void addJTree(JTree tree, JPanel treePanel) {
        tree.getSelectionModel().setSelectionMode(1);
        final JTree copiedFinal = tree;
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)copiedFinal.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                if (node.isLeaf() && nodeInfo instanceof ValidatorErrorNode) {
                    ValidatorErrorNode errorNode = (ValidatorErrorNode)nodeInfo;
                    ValidateFrame.this.detailText.setText(errorNode.getValidationTest().getDetails());
                    if (errorNode instanceof AtomErrorNode) {
                        Atom atom = ((AtomErrorNode)errorNode).getAtom();
                        ValidateFrame.this.rendererModel.setHighlightedAtom((IAtom)atom);
                    } else if (errorNode instanceof BondErrorNode) {
                        Bond bond = ((BondErrorNode)errorNode).getBond();
                        ValidateFrame.this.rendererModel.setHighlightedBond((IBond)bond);
                    }
                }
            }
        });
        treePanel.removeAll();
        tree.validate();
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setPreferredSize(new Dimension(400, 350));
        treePanel.add(scrollPane);
    }

    public void validate(IChemObject object) {
        ValidationReport report = null;
        if (object instanceof ChemModel) {
            report = JChemPaintEditorPanel.getValidatorEngine().validateChemModel((IChemModel)((ChemModel)object));
        } else if (object instanceof Atom) {
            report = JChemPaintEditorPanel.getValidatorEngine().validateAtom((IAtom)((Atom)object));
        } else if (object instanceof IBond) {
            report = JChemPaintEditorPanel.getValidatorEngine().validateBond((IBond)((Bond)object));
        } else if (object instanceof Reaction) {
            report = JChemPaintEditorPanel.getValidatorEngine().validateReaction((IReaction)((Reaction)object));
        } else {
            System.err.println("Cannot validate this object: " + object.getClass().getName());
            return;
        }
        DefaultMutableTreeNode errorsNode = new DefaultMutableTreeNode("errors");
        this.putErrorsInJTree(errorsNode, report);
        this.addJTree(new JTree(errorsNode), this.errorTreePanel);
        DefaultMutableTreeNode warningsNode = new DefaultMutableTreeNode("warnings");
        this.putWarningsInJTree(warningsNode, report);
        this.addJTree(new JTree(warningsNode), this.warningTreePanel);
        DefaultMutableTreeNode cdkErrorsNode = new DefaultMutableTreeNode("errors");
        this.putCDKErrorsInJTree(cdkErrorsNode, report);
        this.addJTree(new JTree(cdkErrorsNode), this.cdkErrorTreePanel);
    }

    private void putErrorsInJTree(DefaultMutableTreeNode rootNode, ValidationReport report) {
        Enumeration errorsEnum = report.getErrors().elements();
        this.putTestsInJTree(rootNode, errorsEnum);
    }

    private void putWarningsInJTree(DefaultMutableTreeNode rootNode, ValidationReport report) {
        Enumeration errorsEnum = report.getWarnings().elements();
        this.putTestsInJTree(rootNode, errorsEnum);
    }

    private void putCDKErrorsInJTree(DefaultMutableTreeNode rootNode, ValidationReport report) {
        Enumeration cdkErrorsEnum = report.getCDKErrors().elements();
        this.putTestsInJTree(rootNode, cdkErrorsEnum);
    }

    private void putTestsInJTree(DefaultMutableTreeNode rootNode, Enumeration errors) {
        while (errors.hasMoreElements()) {
            ValidationTest error = (ValidationTest)errors.nextElement();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            IChemObject object = error.getChemObject();
            if (object instanceof Atom) {
                node.setUserObject(new AtomErrorNode(error, (Atom)object));
                ProblemMarker.markWithError((IChemObject)((Atom)object));
            } else if (object instanceof IBond) {
                node.setUserObject(new BondErrorNode(error, (Bond)object));
            } else {
                node.setUserObject(new ValidatorErrorNode(error));
            }
            rootNode.add(node);
        }
    }

    public void closeFrame() {
        this.dispose();
    }

    class BondErrorNode
    extends ValidatorErrorNode {
        Bond bond;

        BondErrorNode(ValidationTest test, Bond bond) {
            super(test);
            this.bond = bond;
        }

        Bond getBond() {
            return this.bond;
        }
    }

    class AtomErrorNode
    extends ValidatorErrorNode {
        Atom atom;

        AtomErrorNode(ValidationTest test, Atom atom) {
            super(test);
            this.atom = atom;
        }

        Atom getAtom() {
            return this.atom;
        }
    }

    class ValidatorErrorNode {
        ValidationTest test;

        ValidatorErrorNode(ValidationTest test) {
            this.test = test;
        }

        public String toString() {
            return this.test.getError();
        }

        ValidationTest getValidationTest() {
            return this.test;
        }
    }

    class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 8801638051737287899L;

        OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent event) {
            ValidateFrame.this.closeFrame();
        }
    }
}

