/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.io;

import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openscience.cdk.applications.jchempaint.io.IJCPFileFilter;

public class JCPExportFileFilter
extends FileFilter
implements IJCPFileFilter {
    public static final String bmp = "bmp";
    public static final String png = "png";
    public static final String tiff = "tiff";
    public static final String jpg = "jpg";
    public static final String svg = "svg";
    protected Vector types = new Vector();

    public JCPExportFileFilter(String type) {
        this.types.add(type);
    }

    public static void addChoosableFileFilters(JFileChooser chooser) {
        chooser.addChoosableFileFilter(new JCPExportFileFilter(bmp));
        chooser.addChoosableFileFilter(new JCPExportFileFilter(jpg));
        chooser.addChoosableFileFilter(new JCPExportFileFilter(png));
        chooser.addChoosableFileFilter(new JCPExportFileFilter(svg));
        chooser.addChoosableFileFilter(new JCPExportFileFilter(tiff));
    }

    public String getDescription() {
        String type = (String)this.types.elementAt(0);
        String result = "Unknown";
        if (type.equals(png)) {
            result = "PNG";
        } else if (type.equals(bmp)) {
            result = "BMP";
        } else if (type.equals(tiff)) {
            result = "TIFF";
        } else if (type.equals(jpg)) {
            result = "JPEG";
        } else if (type.equals(svg)) {
            result = "Scalable Vector Graphics";
        }
        return result;
    }

    public boolean accept(File f) {
        String extension;
        boolean accepted = false;
        if (f.isDirectory()) {
            accepted = true;
        }
        if ((extension = JCPExportFileFilter.getExtension(f)) != null && this.types.contains(extension)) {
            accepted = true;
        }
        return accepted;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public String getType() {
        return (String)this.types.elementAt(0);
    }

    public void setType(String type) {
        this.types.add(type);
    }
}

