/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.tools.LPR;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class LPRClient
extends AbstractTool {
    String fallback = "%!PS\n/vpos 720 def\n/newline\n {\n/vpos vpos 15 sub def\n72 vpos moveto\n} def \n/printword\n{\nshow\nnewline\nvpos 100 le { \nshowpage\n100 100 moveto\n/vpos 720 def\n/Helvetica findfont 15 scalefont setfont\n} if\n} def \n/nstr 9 string def\n/prt-n\n{\nnstr cvs printword\n} def\n100 100 moveto\n/Helvetica findfont 15 scalefont setfont\n(---) printword \n(Postscript Engine Testpage) printword\n() printword\n() printword\n(Defaultpagesize) printword\ncurrentpagedevice /PageSize get\n(Width: ) show \n0 get prt-n\ncurrentpagedevice /PageSize get\n(Height: ) show \n1 get prt-n\n() printword\n(Printerresolution) printword\ncurrentpagedevice /HWResolution get\n(X: ) show \n0 get prt-n\ncurrentpagedevice /HWResolution get\n(Y: ) show \n1 get prt-n\n() printword\n(Information about Postscriptengine) printword\n(Postscriptengine Type: ) show\nproduct printword\n(Version: ) show\nversion printword\n() printword \nmark\n(\n) \nrevision 10 mod \nrevision 100 mod 10 idiv (.)\nrevision 100 idiv \n(Revision: )\n(\n) \ncounttomark\n{ 17 string cvs show\n} repeat pop  \n() printword \n(Postscript Languagelevel: ) show\n/languagelevel where\n{pop languagelevel}\n{1}\nifelse\n3 string cvs printword \nusertime \nprt-n \nvmstatus\n(Printerram Max.: ) show\nprt-n\n(Printerram Cur.: ) show\nprt-n\n() printword\nshowpage";
    static /* synthetic */ Class class$0;

    static {
        LPRClient.addVersion("$Id: LPRClient.java,v 1.5 2006/08/24 09:57:09 blowagie Exp $");
    }

    public LPRClient() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to print", false, new PdfFilter()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "hostname", "The hostname of the lpr server", clazz.getName()));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "queuename", "The queuename of the lpr server", clazz2.getName()));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.arguments.add(new ToolArgument(this, "copies", "The number of copies to print", clazz3.getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("LPR", true, false, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== LPR OPENED ===");
    }

    public void execute() {
        try {
            String filename = null;
            File pdffile = null;
            if (this.getValue("srcfile") == null) {
                filename = null;
            } else {
                filename = this.getValue("srcfile").toString();
                pdffile = new File(filename);
            }
            if (this.getValue("hostname") == null) {
                throw new InstantiationException("You need to choose a hostname");
            }
            if (this.getValue("queuename") == null) {
                throw new InstantiationException("You need to choose a queuename");
            }
            if (this.getValue("copies") == null) {
                throw new InstantiationException("You need to choose the number of copies");
            }
            LPR lpr = new LPR(this.getValue("hostname").toString(), System.getProperty("user.name"));
            lpr.setCopies(Integer.parseInt(this.getValue("copies").toString()));
            if (filename == null) {
                lpr.print(this.getValue("queuename").toString(), this.fallback, "Version");
            } else {
                lpr.print(this.getValue("queuename").toString(), pdffile, pdffile.getName());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        LPRClient tool = new LPRClient();
        if (args.length < tool.getArguments().size()) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }
}

