/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins.treeview;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.plugins.treeview.ICommonAnalyzer;
import com.lowagie.tools.plugins.treeview.IUpdatenodeview;
import com.lowagie.tools.plugins.treeview.SimpletextTreeNode;
import com.lowagie.tools.plugins.treeview.TextpaneTreeNode;
import com.lowagie.tools.plugins.treeview.UpdateableTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Pagetreenode
extends UpdateableTreeNode {
    private static final long serialVersionUID = -3463874220927052895L;
    private PdfDictionary dictionary;
    private int pagenumber;
    private float width;
    private float height;
    static /* synthetic */ Class class$0;

    public Pagetreenode(PdfDictionary page, int seitennummer, ICommonAnalyzer pageanalyzer, PdfReader pdfreader) {
        PdfObject contents;
        PdfObject reso;
        PdfNumber rotation;
        SimpletextTreeNode info;
        this.dictionary = page;
        this.pagenumber = seitennummer;
        PdfArray arr = (PdfArray)page.get(PdfName.MEDIABOX);
        float curwidth = 0.0f;
        float curheight = 0.0f;
        if (arr != null) {
            ArrayList arl = arr.getArrayList();
            curwidth = Float.parseFloat(arl.get(2).toString());
            curheight = Float.parseFloat(arl.get(3).toString());
            info = new SimpletextTreeNode(PdfName.MEDIABOX + " " + curwidth + "*" + curheight);
            this.add(info);
        }
        PdfArray arrcrop = (PdfArray)page.get(PdfName.CROPBOX);
        float curwidthcrop = 0.0f;
        float curheightcrop = 0.0f;
        if (arrcrop != null) {
            ArrayList arl = arrcrop.getArrayList();
            curwidthcrop = Float.parseFloat(arl.get(2).toString());
            curheightcrop = Float.parseFloat(arl.get(3).toString());
            info = new SimpletextTreeNode(PdfName.CROPBOX + " " + curwidthcrop + "*" + curheightcrop);
            this.add(info);
        }
        if ((rotation = (PdfNumber)PdfReader.getPdfObject(page.get(PdfName.ROTATE))) == null) {
            System.out.println("Rotation missing");
            rotation = new PdfNumber(0);
        } else {
            info = new SimpletextTreeNode(PdfName.ROTATE + " " + rotation);
            this.add(info);
        }
        Rectangle rect = new Rectangle(curwidthcrop, curheightcrop);
        if (rotation.floatValue() == 90.0f || rotation.floatValue() == 270.0f) {
            rect = rect.rotate();
        }
        this.width = rect.width();
        this.height = rect.height();
        PdfArray dict = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
        if (dict != null) {
            this.add(new SimpletextTreeNode(PdfName.ANNOTS + " " + dict.length()));
            SimpletextTreeNode sttn = new SimpletextTreeNode(PdfName.ANNOTS + " " + dict.type());
            this.add(sttn);
            pageanalyzer.iterateObjects(dict, pdfreader, sttn);
        }
        if ((reso = PdfReader.getPdfObject(page.get(PdfName.RESOURCES))) != null) {
            SimpletextTreeNode sttn = new SimpletextTreeNode(PdfName.RESOURCES + " " + reso.type());
            this.add(sttn);
            pageanalyzer.iterateObjects(reso, pdfreader, sttn);
        }
        if ((contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS))) != null) {
            this.add(new TextpaneTreeNode(contents, "Content"));
            if (contents.isStream()) {
                PRStream prstr = (PRStream)contents;
                Set s = prstr.getKeys();
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    System.out.println("Field:" + obj);
                    PdfObject value = PdfReader.getPdfObject(prstr.get((PdfName)obj));
                    System.out.println("Value:" + value);
                }
            }
        }
    }

    public int getPagenumber() {
        return this.pagenumber;
    }

    public String toString() {
        return "Page " + this.pagenumber;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void updateview(IUpdatenodeview updateobject) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<p>");
        sb.append("Page " + this.getPagenumber());
        sb.append("</p>");
        sb.append("<p>");
        sb.append("Size: " + this.getWidth() + "*" + this.getHeight());
        sb.append("</p>");
        Set set = this.dictionary.getKeys();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append("<p>");
            sb.append("Key " + it.next().toString());
            sb.append("</p>");
        }
        sb.append("</html>");
        updateobject.showvalues(sb.toString());
    }

    public Icon getIcon() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lowagie.tools.plugins.treeview.TreeViewInternalFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new ImageIcon(clazz.getResource("pageonly.gif"));
    }
}

