/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;

abstract class AtomSetCollectionReader
extends Parser {
    AtomSetCollection atomSetCollection;
    JmolAdapter.Logger logger;
    BufferedReader reader;
    String line;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    int desiredModelNumber;
    int modelNumber;
    boolean iHaveDesiredModel;
    String spaceGroup;
    UnitCell unitcell;
    float[] notionalUnitCell;
    int[] latticeCells = new int[3];
    int desiredSpaceGroupIndex;
    boolean doApplySymmetry;
    boolean doConvertToFractional;
    boolean fileCoordinatesAreFractional;
    boolean ignoreFileUnitCell;
    boolean ignoreFileSymmetryOperators;
    boolean ignoreFileSpaceGroupName;
    boolean iHaveUnitCell;
    boolean iHaveCartesianToFractionalMatrix;
    boolean iHaveFractionalCoordinates;
    boolean iHaveSymmetryOperators;
    boolean needToApplySymmetry;

    AtomSetCollectionReader() {
    }

    void setLogger(JmolAdapter.Logger logger) {
        this.logger = logger;
    }

    abstract AtomSetCollection readAtomSetCollection(BufferedReader var1) throws Exception;

    AtomSetCollection readAtomSetCollectionFromDOM(Object DOMNode) throws Exception {
        return null;
    }

    void initialize() {
        this.modelNumber = 0;
        this.desiredModelNumber = -1;
        this.iHaveDesiredModel = false;
        this.latticeCells[2] = 0;
        this.latticeCells[1] = 0;
        this.latticeCells[0] = 0;
        this.desiredSpaceGroupIndex = -1;
        this.ignoreFileUnitCell = false;
        this.ignoreFileSpaceGroupName = false;
        this.ignoreFileSymmetryOperators = false;
        this.doConvertToFractional = false;
        this.doApplySymmetry = false;
        this.fileCoordinatesAreFractional = false;
        this.iHaveUnitCell = false;
        this.iHaveCartesianToFractionalMatrix = false;
        this.iHaveFractionalCoordinates = false;
        this.iHaveSymmetryOperators = false;
        this.initializeSymmetry();
    }

    void initialize(int[] params) {
        this.initialize();
        if (params == null) {
            return;
        }
        this.desiredModelNumber = params[0];
        this.latticeCells[0] = params[1];
        this.latticeCells[1] = params[2];
        this.latticeCells[2] = params[3];
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0 && this.latticeCells[2] > 0 || this.latticeCells[0] > 9 && this.latticeCells[1] > 9;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (params.length >= 5) {
            this.desiredSpaceGroupIndex = params[4];
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex >= 0;
            boolean bl2 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (params.length >= 11) {
            this.setUnitCell((float)params[5] / 10000.0f, (float)params[6] / 10000.0f, (float)params[7] / 10000.0f, (float)params[8] / 10000.0f, (float)params[9] / 10000.0f, (float)params[10] / 10000.0f);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
    }

    private void initializeSymmetry() {
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int i = 22;
            while (--i >= 0) {
                this.notionalUnitCell[i] = Float.NaN;
            }
            this.unitcell = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified";
        }
        this.needToApplySymmetry = false;
    }

    void initializeCartesianToFractional() {
        for (int i = 0; i < 16; ++i) {
            this.notionalUnitCell[6 + i] = i % 5 == 0 ? 1 : 0;
        }
    }

    void newAtomSet(String name) {
        if (this.atomSetCollection.currentAtomSetIndex >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(name);
        }
        this.logger.log(name);
    }

    void setSpaceGroupName(String name) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = name.trim();
    }

    void setSymmetryOperator(String jonesFaithful) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells);
        if (!this.atomSetCollection.addSymmetry(jonesFaithful)) {
            Logger.warn("Skipping symmetry operation " + jonesFaithful);
        }
        this.iHaveSymmetryOperators = true;
    }

    void setUnitCellItem(int i, float x) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (i >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[i] = x;
        if (this.logger != null) {
            this.logger.log("setunitcellitem " + i + " " + x);
        }
        if (i < 6) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else {
            this.iHaveCartesianToFractionalMatrix = this.checkUnitCell(22);
        }
    }

    void setUnitCell(float a, float b, float c, float alpha, float beta, float gamma) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.notionalUnitCell[0] = a;
        this.notionalUnitCell[1] = b;
        this.notionalUnitCell[2] = c;
        this.notionalUnitCell[3] = alpha;
        this.notionalUnitCell[4] = beta;
        this.notionalUnitCell[5] = gamma;
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.unitcell = new UnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    void setFractionalCoordinates(boolean TF) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = TF;
    }

    void setAtomCoord(Atom atom, float x, float y, float z) {
        atom.x = x;
        atom.y = y;
        atom.z = z;
        this.setAtomCoord(atom);
    }

    void setAtomCoord(Atom atom) {
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.unitcell != null) {
            this.unitcell.toFractional(atom);
            this.iHaveFractionalCoordinates = true;
        }
        this.needToApplySymmetry = true;
    }

    void applySymmetry() {
        if (!this.needToApplySymmetry || !this.iHaveUnitCell) {
            this.initializeSymmetry();
            return;
        }
        this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
        this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell);
        this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
        if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
            this.atomSetCollection.setLatticeCells(this.latticeCells);
            if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                SpaceGroup sg = SpaceGroup.createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup, this.notionalUnitCell);
                if (sg != null) {
                    if (Logger.isActiveLevel(0)) {
                        Logger.debug("using generated space group " + sg.dumpInfo());
                    }
                    this.atomSetCollection.setAtomSetSpaceGroupName(sg.getName());
                    this.atomSetCollection.applySymmetry(sg);
                }
            } else {
                this.atomSetCollection.applySymmetry();
            }
        }
        this.initializeSymmetry();
    }

    static String getElementSymbol(int elementNumber) {
        return JmolConstants.elementSymbolFromNumber(elementNumber);
    }

    void fillDataBlock(String[][] data) throws Exception {
        int nLines = data.length;
        for (int i = 0; i < nLines; ++i) {
            data[i] = this.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    void discardLines(int nLines) throws Exception {
        int i = nLines;
        while (--i >= 0) {
            this.readLine();
        }
    }

    String discardLinesUntilStartsWith(String startsWith) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(startsWith)) {
        }
        return this.line;
    }

    String discardLinesUntilContains(String containsMatch) throws Exception {
        while (this.readLine() != null && this.line.indexOf(containsMatch) < 0) {
        }
        return this.line;
    }

    void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    void checkLineForScript() {
        int pt;
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setAtomSetCollectionProperty("noautobond", "true");
        }
        if ((pt = this.line.indexOf("#jmolscript:")) >= 0) {
            String previousScript;
            String script = this.line.substring(pt + 12, this.line.length());
            if (script.indexOf("#") >= 0) {
                script = script.substring(0, script.indexOf("#"));
            }
            previousScript = (previousScript = this.atomSetCollection.getAtomSetCollectionProperty("jmolscript")) == null ? "" : previousScript + ";";
            this.atomSetCollection.setAtomSetCollectionProperty("jmolscript", previousScript + script);
            this.line = this.line.substring(0, pt).trim();
        }
    }

    String readLine() throws Exception {
        this.line = this.reader.readLine();
        return this.line;
    }

    String readLineTrimmed() throws Exception {
        this.readLine();
        if (this.line == null) {
            this.line = "";
        }
        this.line = this.line.trim();
        return this.line;
    }
}

