/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Node;
import org.jmol.bspt.Tuple;

class Leaf
extends Element {
    Tuple[] tuples;

    Leaf(Bspt bspt) {
        this.bspt = bspt;
        this.count = 0;
        this.tuples = new Tuple[2];
    }

    Leaf(Bspt bspt, Leaf leaf, int countToKeep) {
        this(bspt);
        for (int i = countToKeep; i < 2; ++i) {
            this.tuples[this.count++] = leaf.tuples[i];
            leaf.tuples[i] = null;
        }
        leaf.count = countToKeep;
    }

    void sort(int dim) {
        int i = this.count;
        while (--i > 0) {
            Tuple champion = this.tuples[i];
            float championValue = champion.getDimensionValue(dim);
            int j = i;
            while (--j >= 0) {
                Tuple challenger = this.tuples[j];
                float challengerValue = challenger.getDimensionValue(dim);
                if (!(challengerValue > championValue)) continue;
                this.tuples[i] = challenger;
                this.tuples[j] = champion;
                champion = challenger;
                championValue = challengerValue;
            }
        }
    }

    Element addTuple(int level, Tuple tuple) {
        if (this.count < 2) {
            this.tuples[this.count++] = tuple;
            return this;
        }
        Node node = new Node(this.bspt, level, this);
        return node.addTuple(level, tuple);
    }
}

