/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Text;

class TextShape
extends Shape {
    Hashtable texts = new Hashtable();
    Text currentText;
    Font3D currentFont;
    Object currentColor;
    Object currentBgColor;
    boolean isAll;

    TextShape() {
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.debug("TextShape.setProperty(" + propertyName + "," + value + ")");
        if ("allOff" == propertyName) {
            this.currentText = null;
            this.isAll = true;
            this.texts = new Hashtable();
            return;
        }
        if ("off" == propertyName) {
            if (this.isAll) {
                this.texts = new Hashtable();
                this.isAll = false;
                this.currentText = null;
            }
            if (this.currentText == null) {
                return;
            }
            this.texts.remove(this.currentText.target);
            this.currentText = null;
            return;
        }
        if ("align" == propertyName) {
            String align = (String)value;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration e = this.texts.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setAlignment(align);
                    }
                }
                return;
            }
            if (!this.currentText.setAlignment(align)) {
                Logger.error("unrecognized align:" + align);
            }
            return;
        }
        if ("bgcolor" == propertyName) {
            this.currentBgColor = value;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration e = this.texts.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setBgColix(value);
                    }
                }
                return;
            }
            this.currentText.setBgColix(value);
            return;
        }
        if ("color" == propertyName) {
            this.currentColor = value;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration e = this.texts.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setColix(value);
                    }
                }
                return;
            }
            this.currentText.setColix(value);
            return;
        }
        if ("text" == propertyName) {
            String text = (String)value;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration e = this.texts.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setText(text);
                    }
                }
                return;
            }
            this.currentText.setText(text);
            return;
        }
        if ("font" == propertyName) {
            this.currentFont = (Font3D)value;
            if (this.currentText == null) {
                if (this.isAll) {
                    Enumeration e = this.texts.elements();
                    while (e.hasMoreElements()) {
                        ((Text)e.nextElement()).setFont(this.currentFont);
                    }
                }
                return;
            }
            this.currentText.setFont(this.currentFont);
            return;
        }
        if ("target" == propertyName) {
            String target = (String)value;
            this.isAll = ((String)value).equals("all");
            if (this.isAll || target.equals("none")) {
                this.currentText = null;
            }
            return;
        }
        if ("translucency" == propertyName) {
            Logger.warn("translucent TextShape not implemented");
            return;
        }
        if ("xpos" == propertyName) {
            if (this.currentText != null) {
                this.currentText.setMovableX((Integer)value);
            }
            return;
        }
        if ("ypos" == propertyName) {
            if (this.currentText != null) {
                this.currentText.setMovableY(this.currentText.windowHeight - (Integer)value);
            }
            return;
        }
        if ("%xpos" == propertyName) {
            if (this.currentText != null) {
                this.currentText.setMovableX((Integer)value * this.currentText.windowWidth / 100);
            }
            return;
        }
        if ("%ypos" == propertyName) {
            if (this.currentText != null) {
                this.currentText.setMovableY(this.currentText.windowHeight * (100 - (Integer)value) / 100);
            }
            return;
        }
    }
}

