/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import org.guha.rcdk.util.Misc;
import org.guha.rcdk.view.ImageSelection;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class MoleculeImageToClipboard {
    public static void copyImageToClipboard(IAtomContainer molecule, int width, int height) throws Exception {
        if (!ConnectivityChecker.isConnected((IAtomContainer)molecule)) {
            throw new CDKException("Molecule must be connected");
        }
        molecule = AtomContainerManipulator.removeHydrogens((IAtomContainer)molecule);
        try {
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)molecule);
        }
        catch (CDKException e) {
            throw new Exception("Error in aromatcity detection");
        }
        molecule = Misc.getMoleculeWithCoordinates(molecule);
        Image image = MoleculeImageToClipboard.getImage(molecule, width, height);
        ImageSelection.copyImageToClipboard(image);
    }

    private static Image getImage(IAtomContainer molecule, int width, int height) throws IOException {
        Rectangle drawArea = new Rectangle(width, height);
        BufferedImage image = new BufferedImage(width, height, 1);
        ArrayList<Object> generators = new ArrayList<Object>();
        generators.add(new BasicSceneGenerator());
        generators.add(new BasicBondGenerator());
        generators.add(new BasicAtomGenerator());
        AtomContainerRenderer renderer = new AtomContainerRenderer(generators, (IFontManager)new AWTFontManager());
        renderer.setup(molecule, drawArea);
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        renderer.paint(molecule, (IDrawVisitor)new AWTDrawVisitor(g2), (Rectangle2D)drawArea, true);
        return image;
    }

    public static void main(String[] args) throws Exception {
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer mol = sp.parseSmiles("c1ccccc1CC(=O)C1COCNC1");
        MoleculeImageToClipboard.copyImageToClipboard(mol, 300, 300);
    }
}

