/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.guha.rcdk.view.RcdkDepictor;
import org.guha.rcdk.view.panels.MoleculeCell;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;

public class ViewMolecule2D
extends JFrame {
    MoleculeCell panel;

    public ViewMolecule2D(IAtomContainer molecule) throws Exception {
        this(molecule, 300, 300);
    }

    public ViewMolecule2D(IAtomContainer molecule, int width, int height) throws Exception {
        this(molecule, new RcdkDepictor(width, height, 1.3, "cow", "off", "reagents", true, false, 100, ""));
    }

    public ViewMolecule2D(IAtomContainer molecule, RcdkDepictor depictor) throws Exception {
        this.panel = new MoleculeCell(molecule, depictor);
        this.setTitle("2D Viewer");
        this.addWindowListener(new ApplicationCloser());
        this.setSize(depictor.getWidth(), depictor.getHeight());
    }

    public void draw() {
        this.getContentPane().add(this.panel);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] arg) throws Exception {
        String home = "/Users/guhar/";
        String[] fname = new String[]{home + "src/cdkr/data/dan001.sdf", home + "src/cdkr/data/dan002.sdf", home + "src/cdkr/data/dan003.sdf"};
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        sp.kekulise(false);
        IAtomContainer mol = sp.parseSmiles("c1ccccc1");
        ViewMolecule2D v2d = new ViewMolecule2D(mol);
        v2d.draw();
    }

    class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ViewMolecule2D.this.dispose();
        }
    }
}

