/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.Iterator;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class AddAtomsAndBondsEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -7667903450980188402L;
    private IChemModel chemModel;
    private IAtomContainer undoRedoContainer;
    private String type;
    private IChemModelRelay chemModelRelay = null;

    public AddAtomsAndBondsEdit(IChemModel chemModel, IAtomContainer undoRedoContainer, String type, IChemModelRelay chemModelRelay) {
        this.chemModel = chemModel;
        this.undoRedoContainer = undoRedoContainer;
        this.type = type;
        this.chemModelRelay = chemModelRelay;
    }

    @Override
    public void redo() {
        int i;
        IAtomContainer container = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Iterator containers = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel).iterator();
        while (containers.hasNext()) {
            container.add((IAtomContainer)containers.next());
        }
        for (i = 0; i < this.undoRedoContainer.getBondCount(); ++i) {
            IBond bond = this.undoRedoContainer.getBond(i);
            container.addBond(bond);
        }
        for (i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            container.addAtom(atom);
        }
        this.chemModelRelay.updateAtoms(container, container.atoms());
        IMolecule molecule = (IMolecule)container.getBuilder().newInstance(IMolecule.class, new Object[]{container});
        IMoleculeSet moleculeSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)molecule);
        this.chemModel.setMoleculeSet(moleculeSet);
    }

    @Override
    public void undo() {
        int i;
        for (i = 0; i < this.undoRedoContainer.getBondCount(); ++i) {
            IBond bond = this.undoRedoContainer.getBond(i);
            ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IBond)bond).removeBond(bond);
        }
        for (i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom).removeAtom(atom);
        }
        for (IAtomContainer container : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            this.chemModelRelay.updateAtoms(container, container.atoms());
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

