/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public abstract class AbstractAWTDrawVisitor
implements IDrawVisitor {
    protected AffineTransform transform = null;

    public int[] transformPoint(double x, double y) {
        double[] src = new double[]{x, y};
        double[] dest = new double[2];
        this.transform.transform(src, 0, dest, 0, 1);
        return new int[]{(int)dest[0], (int)dest[1]};
    }

    protected Rectangle2D getTextBounds(String text, double x, double y, Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, g);
        double widthPad = 3.0;
        double heightPad = 1.0;
        double w = bounds.getWidth() + widthPad;
        double h = bounds.getHeight() + heightPad;
        int[] p = this.transformPoint(x, y);
        return new Rectangle2D.Double((double)p[0] - w / 2.0, (double)p[1] - h / 2.0, w, h);
    }

    protected Point getTextBasePoint(String text, double x, double y, Graphics2D g) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(text, g);
        int[] p = this.transformPoint(x, y);
        int baseX = (int)((double)p[0] - stringBounds.getWidth() / 2.0);
        int baseY = (int)((double)p[1] + ((double)fm.getAscent() - stringBounds.getHeight() / 2.0));
        return new Point(baseX, baseY);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }
}

