/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import signature.AbstractGraphBuilder;

@TestClass(value="org.openscience.cdk.signature.MoleculeFromSignatureBuilderTest")
public class MoleculeFromSignatureBuilder
extends AbstractGraphBuilder {
    private IChemObjectBuilder builder;
    private IAtomContainer container;

    public MoleculeFromSignatureBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @Override
    @TestMethod(value="makeEdgeTest_singleBond,makeEdgeTest_doubleBond,makeEdgeTest_tripleBond")
    public void makeEdge(int vertexIndex1, int vertexIndex2, String vertexSymbol1, String vertexSymbol2, String edgeLabel) {
        if (edgeLabel.equals("")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.SINGLE);
        } else if (edgeLabel.equals("=")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.DOUBLE);
        } else if (edgeLabel.equals("#")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.TRIPLE);
        }
    }

    @Override
    @TestMethod(value="makeGraphTest")
    public void makeGraph() {
        this.container = this.builder.newInstance(IAtomContainer.class, new Object[0]);
    }

    @Override
    @TestMethod(value="makeVertexTest")
    public void makeVertex(String label) {
        this.container.addAtom(this.builder.newInstance(IAtom.class, label));
    }

    @TestMethod(value="getAtomContainerTest")
    public IAtomContainer getAtomContainer() {
        return this.container;
    }
}

