/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import org.openscience.cdk.math.Complex;

public class IVector {
    public double[] realvector;
    public double[] imagvector;
    public int size;

    public IVector(int size) {
        this.realvector = new double[size];
        this.imagvector = new double[size];
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public IVector add(IVector b) {
        IVector result = new IVector(this.size);
        this.add(b, result);
        return result;
    }

    public void add(IVector b, IVector result) {
        if (b == null || this.size != b.size) {
            return;
        }
        if (result.size != this.size) {
            result.reshape(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            result.realvector[i] = this.realvector[i] + b.realvector[i];
            result.imagvector[i] = this.imagvector[i] + b.imagvector[i];
        }
    }

    public IVector sub(IVector b) {
        IVector result = new IVector(this.size);
        this.sub(b, result);
        return result;
    }

    public void sub(IVector b, IVector result) {
        if (b == null || this.size != b.size) {
            return;
        }
        if (result.size != this.size) {
            result.reshape(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            result.realvector[i] = this.realvector[i] - b.realvector[i];
            result.imagvector[i] = this.imagvector[i] - b.imagvector[i];
        }
    }

    public IVector mul(double b) {
        IVector result = new IVector(this.size);
        this.mul(b, result);
        return result;
    }

    public void mul(double b, IVector result) {
        if (result.size != this.size) {
            result.reshape(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            result.realvector[i] = this.realvector[i] * b;
            result.imagvector[i] = this.imagvector[i] * b;
        }
    }

    public Complex dot(IVector b) {
        if (b == null || this.size != b.size) {
            return new Complex(Double.NaN, Double.NaN);
        }
        Complex result = new Complex(0.0, 0.0);
        for (int i = 0; i < this.size; ++i) {
            result.real += this.realvector[i] * b.realvector[i] - this.imagvector[i] * b.imagvector[i];
            result.imag += this.realvector[i] * b.imagvector[i] + this.imagvector[i] * b.realvector[i];
        }
        return result;
    }

    public IVector duplicate() {
        IVector result = new IVector(this.size);
        this.duplicate(result);
        return result;
    }

    public void duplicate(IVector result) {
        if (result.size != this.size) {
            result.reshape(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            result.realvector[i] = this.realvector[i];
            result.imagvector[i] = this.imagvector[i];
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[ ");
        for (int i = 0; i < this.size - 1; ++i) {
            str.append(this.realvector[i] + "+i*" + this.imagvector[i] + " ");
        }
        str.append(this.realvector[this.size - 1] + "+i*" + this.imagvector[this.size - 1] + " ]");
        return str.toString();
    }

    public void reshape(int newsize) {
        int i;
        if (newsize == this.size || newsize <= 0) {
            return;
        }
        double[] newrealvector = new double[newsize];
        double[] newimagvector = new double[newsize];
        int min = Math.min(this.size, newsize);
        for (i = 0; i < min; ++i) {
            newrealvector[i] = this.realvector[i];
            newimagvector[i] = this.imagvector[i];
        }
        for (i = min; i < newsize; ++i) {
            newrealvector[i] = 0.0;
            newimagvector[i] = 0.0;
        }
        this.realvector = newrealvector;
        this.imagvector = newimagvector;
        this.size = newsize;
    }
}

