/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.isomorphism.matchers.CTFileQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.MDLV2000ReaderTest")
public class MDLV2000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Reader.class);
    private BooleanIOSetting forceReadAs3DCoords;
    private BooleanIOSetting interpretHydrogenIsotopes;
    private List<IAtom> atomsByLinePosition;

    public MDLV2000Reader() {
        this(new StringReader(""));
    }

    public MDLV2000Reader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public MDLV2000Reader(InputStream in, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(in), mode);
    }

    public MDLV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLV2000Format.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IAtomContainer) {
            return (T)this.readAtomContainer((IAtomContainer)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        }
        if ((m = this.readAtomContainer(chemModel.getBuilder().newInstance(IMolecule.class, new Object[0]))) != null && m instanceof IMolecule) {
            setOfMolecules.addAtomContainer((IMolecule)m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        IAtomContainer m = this.readAtomContainer(chemFile.getBuilder().newInstance(IMolecule.class, new Object[0]));
        if (m != null && m instanceof IMolecule) {
            setOfMolecules.addMolecule((IMolecule)m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        chemSequence.addChemModel(chemModel);
        setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                logger.debug("line: ", line);
                String str = new String(line);
                if (str.equals("$$$$")) {
                    m = this.readAtomContainer(chemFile.getBuilder().newInstance(IMolecule.class, new Object[0]));
                    if (m == null || !(m instanceof IMolecule)) continue;
                    setOfMolecules.addMolecule((IMolecule)m);
                    chemModel.setMoleculeSet(setOfMolecules);
                    chemSequence.addChemModel(chemModel);
                    setOfMolecules = chemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                    chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    continue;
                }
                if (m == null) continue;
                String fieldName = null;
                if (str.startsWith("> ")) {
                    int index2;
                    str.substring(2);
                    int index = str.indexOf("<");
                    if (index != -1 && (index2 = str.substring(index).indexOf(">")) != -1) {
                        fieldName = str.substring(index + 1, index + index2);
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                StringBuilder data = new StringBuilder();
                int dataLineCount = 0;
                boolean lineIsContinued = false;
                while ((line = this.input.readLine()) != null) {
                    if (line.equals(" ") && dataLineCount == 0) {
                        data.append(line);
                        lineIsContinued = false;
                        if (lineIsContinued || ++dataLineCount <= 1) continue;
                        data.append(System.getProperty("line.separator"));
                        continue;
                    }
                    if ((line = line.trim()).length() == 0) break;
                    if (line.equals("$$$$")) {
                        logger.error("Expecting data line here, but found end of molecule: ", line);
                        break;
                    }
                    logger.debug("data line: ", line);
                    lineIsContinued = false;
                    if (!lineIsContinued && ++dataLineCount > 1) {
                        data.append(System.getProperty("line.separator"));
                    }
                    data.append(line);
                    if (line.length() != 80) continue;
                    lineIsContinued = true;
                }
                if (fieldName == null) continue;
                logger.info("fieldName, data: ", fieldName, ", ", data);
                m.setProperty(fieldName, data.toString());
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (Exception exception) {
            String error = "Error while parsing SDF";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error(error);
            throw new CDKException(error, exc);
        }
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private IAtomContainer readAtomContainer(IAtomContainer molecule) throws CDKException {
        logger.debug("Reading new molecule");
        IAtomContainer outputContainer = null;
        int linecount = 0;
        int atoms = 0;
        int bonds = 0;
        int atom1 = 0;
        int atom2 = 0;
        int order = 0;
        IBond.Stereo stereo = (IBond.Stereo)((Object)CDKConstants.UNSET);
        int RGroupCounter = 1;
        int Rnumber = 0;
        String[] rGroup = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        String title = null;
        String remark = null;
        String line = "";
        HashMap<Integer, IPseudoAtom> rAtoms = new HashMap<Integer, IPseudoAtom>();
        try {
            IsotopeFactory isotopeFactory = IsotopeFactory.getInstance(molecule.getBuilder());
            logger.info("Reading header");
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return null;
            }
            logger.debug("Line " + linecount + ": " + line);
            if (line.startsWith("$$$$")) {
                logger.debug("File is empty, returning empty molecule");
                return molecule;
            }
            if (line.length() > 0) {
                title = line;
            }
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            if (line.length() > 0) {
                remark = line;
            }
            logger.info("Reading rest of file");
            line = this.input.readLine();
            logger.debug("Line " + ++linecount + ": " + line);
            if (line.length() == 0) {
                do {
                    line = this.input.readLine();
                    ++linecount;
                    if (line != null) continue;
                    return null;
                } while (!line.startsWith("$$$$"));
                return molecule;
            }
            if (line.contains("V3000") || line.contains("v3000")) {
                this.handleError("This file must be read with the MDLV3000Reader.");
            } else if (!line.contains("V2000") && !line.contains("v2000")) {
                this.handleError("This file must be read with the MDLReader.");
            }
            atoms = Integer.parseInt(line.substring(0, 3).trim());
            ArrayList<IAtom> atomList = new ArrayList<IAtom>();
            logger.debug("Atomcount: " + atoms);
            bonds = Integer.parseInt(line.substring(3, 6).trim());
            logger.debug("Bondcount: " + bonds);
            ArrayList<IBond> bondList = new ArrayList<IBond>();
            logger.info("Reading atom block");
            this.atomsByLinePosition = new ArrayList<IAtom>();
            this.atomsByLinePosition.add(null);
            int atomBlockLineNumber = 0;
            for (int f = 0; f < atoms; ++f) {
                IAtom atom;
                block129: {
                    line = this.input.readLine();
                    ++linecount;
                    ++atomBlockLineNumber;
                    x = Double.parseDouble(line.substring(0, 10).trim());
                    y = Double.parseDouble(line.substring(10, 20).trim());
                    z = Double.parseDouble(line.substring(20, 30).trim());
                    totalX += Math.abs(x);
                    totalY += Math.abs(y);
                    totalZ += Math.abs(z);
                    logger.debug("Coordinates: " + x + "; " + y + "; " + z);
                    String element = line.substring(31, 34).trim();
                    logger.debug("Atom type: ", element);
                    if (isotopeFactory.isElement(element)) {
                        atom = isotopeFactory.configure(molecule.getBuilder().newInstance(IAtom.class, element));
                    } else if ("A".equals(element)) {
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    } else if ("Q".equals(element)) {
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    } else if ("*".equals(element)) {
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    } else if ("LP".equals(element)) {
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    } else if ("L".equals(element)) {
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    } else if (element.equals("R") || element.length() > 0 && element.charAt(0) == 'R') {
                        logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                        rGroup = element.split("^R");
                        atom = null;
                        if (rGroup.length > 1) {
                            try {
                                RGroupCounter = Rnumber = Integer.valueOf(rGroup[rGroup.length - 1]).intValue();
                                element = "R" + Rnumber;
                                atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                            }
                            catch (Exception ex) {
                                atom = molecule.getBuilder().newInstance(IPseudoAtom.class, "R");
                                rAtoms.put(atomBlockLineNumber, (IPseudoAtom)atom);
                            }
                        } else {
                            atom = molecule.getBuilder().newInstance(IPseudoAtom.class, "R");
                        }
                    } else {
                        this.handleError("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.", linecount, 32, 35);
                        atom = molecule.getBuilder().newInstance(IPseudoAtom.class, element);
                    }
                    atom.setPoint3d(new Point3d(x, y, z));
                    String massDiffString = line.substring(34, 36).trim();
                    logger.debug("Mass difference: ", massDiffString);
                    if (!(atom instanceof IPseudoAtom)) {
                        try {
                            int massDiff = Integer.parseInt(massDiffString);
                            if (massDiff != 0) {
                                IIsotope major = IsotopeFactory.getInstance(molecule.getBuilder()).getMajorIsotope(element);
                                atom.setMassNumber(major.getMassNumber() + massDiff);
                            }
                        }
                        catch (Exception exception) {
                            this.handleError("Could not parse mass difference field.", linecount, 35, 37, exception);
                        }
                    } else {
                        logger.error("Cannot set mass difference for a non-element!");
                    }
                    if (line.length() >= 51) {
                        String valenceString = this.removeNonDigits(line.substring(48, 51));
                        logger.debug("Valence: ", valenceString);
                        if (!(atom instanceof IPseudoAtom)) {
                            try {
                                int valence = Integer.parseInt(valenceString);
                                if (valence == 0) break block129;
                                if (valence == 15) {
                                    atom.setValency(0);
                                    break block129;
                                }
                                atom.setValency(valence);
                            }
                            catch (Exception exception) {
                                this.handleError("Could not parse valence information field", linecount, 49, 52, exception);
                            }
                        } else {
                            logger.error("Cannot set valence information for a non-element!");
                        }
                    }
                }
                String chargeCodeString = line.substring(36, 39).trim();
                logger.debug("Atom charge code: ", chargeCodeString);
                int chargeCode = Integer.parseInt(chargeCodeString);
                if (chargeCode != 0) {
                    if (chargeCode == 1) {
                        atom.setFormalCharge(3);
                    } else if (chargeCode == 2) {
                        atom.setFormalCharge(2);
                    } else if (chargeCode == 3) {
                        atom.setFormalCharge(1);
                    } else if (chargeCode != 4) {
                        if (chargeCode == 5) {
                            atom.setFormalCharge(-1);
                        } else if (chargeCode == 6) {
                            atom.setFormalCharge(-2);
                        } else if (chargeCode == 7) {
                            atom.setFormalCharge(-3);
                        }
                    }
                }
                try {
                    String reactionAtomIDString = line.substring(60, 63).trim();
                    logger.debug("Parsing mapping id: ", reactionAtomIDString);
                    try {
                        int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                        if (reactionAtomID != 0) {
                            atom.setProperty("cdk:AtomAtomMapping", reactionAtomID);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("Mapping number ", reactionAtomIDString, " is not an integer.");
                        logger.debug(exception);
                    }
                }
                catch (Exception exception) {
                    logger.warn("A few fields are missing. Older MDL MOL file?");
                }
                if (line.length() >= 78) {
                    double shift = Double.parseDouble(line.substring(69, 80).trim());
                    atom.setProperty("first shift", shift);
                }
                if (line.length() >= 87) {
                    double shift = Double.parseDouble(line.substring(79, 87).trim());
                    atom.setProperty("second shift", shift);
                }
                atomList.add(atom);
                this.atomsByLinePosition.add(atom);
            }
            if (totalX == 0.0 && totalY == 0.0 && totalZ == 0.0) {
                logger.info("All coordinates are 0.0");
                if (atomList.size() == 1) {
                    ((IAtom)atomList.get(0)).setPoint2d(new Point2d(x, y));
                } else {
                    for (IAtom atomToUpdate : atomList) {
                        atomToUpdate.setPoint3d(null);
                    }
                }
            } else if (totalZ == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                logger.info("Total 3D Z is 0.0, interpreting it as a 2D structure");
                for (IAtom atomToUpdate : atomList) {
                    Point3d p3d = atomToUpdate.getPoint3d();
                    if (p3d == null) continue;
                    atomToUpdate.setPoint2d(new Point2d(p3d.x, p3d.y));
                    atomToUpdate.setPoint3d(null);
                }
            }
            logger.info("Reading bond block");
            int queryBondCount = 0;
            for (int f = 0; f < bonds; ++f) {
                line = this.input.readLine();
                ++linecount;
                atom1 = Integer.parseInt(line.substring(0, 3).trim());
                atom2 = Integer.parseInt(line.substring(3, 6).trim());
                order = Integer.parseInt(line.substring(6, 9).trim());
                if (line.length() >= 12) {
                    int mdlStereo;
                    int n = mdlStereo = line.length() > 12 ? Integer.parseInt(line.substring(9, 12).trim()) : Integer.parseInt(line.substring(9).trim());
                    if (mdlStereo == 1) {
                        stereo = IBond.Stereo.UP;
                    } else if (mdlStereo == 6) {
                        stereo = IBond.Stereo.DOWN;
                    } else if (mdlStereo == 0) {
                        stereo = order == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
                    } else if (mdlStereo == 3 && order == 2) {
                        stereo = IBond.Stereo.E_OR_Z;
                    } else if (mdlStereo == 4) {
                        stereo = IBond.Stereo.UP_OR_DOWN;
                    }
                } else {
                    this.handleError("Missing expected stereo field at line: ", linecount, 10, 12);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Bond: " + atom1 + " - " + atom2 + "; order " + order);
                }
                IAtom a1 = (IAtom)atomList.get(atom1 - 1);
                IAtom a2 = (IAtom)atomList.get(atom2 - 1);
                IBond newBond = null;
                if (order >= 1 && order <= 3) {
                    IBond.Order cdkOrder = IBond.Order.SINGLE;
                    if (order == 2) {
                        cdkOrder = IBond.Order.DOUBLE;
                    }
                    if (order == 3) {
                        cdkOrder = IBond.Order.TRIPLE;
                    }
                    newBond = stereo != null ? molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder, stereo}) : molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, cdkOrder});
                } else if (order == 4) {
                    newBond = stereo != null ? molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE, stereo}) : molecule.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.SINGLE});
                    newBond.setFlag(5, true);
                    a1.setFlag(5, true);
                    a2.setFlag(5, true);
                } else {
                    ++queryBondCount;
                    newBond = new CTFileQueryBond();
                    IAtom[] bondAtoms = new IAtom[]{a1, a2};
                    newBond.setAtoms(bondAtoms);
                    newBond.setOrder(null);
                    CTFileQueryBond.Type queryBondType = null;
                    switch (order) {
                        case 5: {
                            queryBondType = CTFileQueryBond.Type.SINGLE_OR_DOUBLE;
                            break;
                        }
                        case 6: {
                            queryBondType = CTFileQueryBond.Type.SINGLE_OR_AROMATIC;
                            break;
                        }
                        case 7: {
                            queryBondType = CTFileQueryBond.Type.DOUBLE_OR_AROMATIC;
                            break;
                        }
                        case 8: {
                            queryBondType = CTFileQueryBond.Type.ANY;
                        }
                    }
                    ((CTFileQueryBond)newBond).setType(queryBondType);
                    newBond.setStereo(stereo);
                }
                bondList.add(newBond);
            }
            outputContainer = queryBondCount == 0 ? molecule : new QueryAtomContainer();
            outputContainer.setProperty("cdk:Title", title);
            outputContainer.setProperty("cdk:Remark", remark);
            for (IAtom at : atomList) {
                outputContainer.addAtom(at);
            }
            for (IBond bnd : bondList) {
                outputContainer.addBond(bnd);
            }
            logger.info("Reading property block");
            while (true) {
                line = this.input.readLine();
                ++linecount;
                if (line == null) {
                    this.handleError("The expected property block is missing!", linecount, 0, 0);
                }
                if (line.startsWith("M  END")) break;
                boolean lineRead = false;
                if (line.startsWith("M  CHG")) {
                    int infoCount = Integer.parseInt(line.substring(6, 9).trim());
                    StringTokenizer st = new StringTokenizer(line.substring(9));
                    for (int i = 1; i <= infoCount; ++i) {
                        String token = st.nextToken();
                        int atomNumber = Integer.parseInt(token.trim());
                        token = st.nextToken();
                        int charge = Integer.parseInt(token.trim());
                        outputContainer.getAtom(atomNumber - 1).setFormalCharge(charge);
                    }
                } else if (line.matches("A\\s{1,4}\\d+")) {
                    int aliasAtomNumber = Integer.parseInt(line.replaceFirst("A\\s{1,4}", "")) - RGroupCounter;
                    line = this.input.readLine();
                    ++linecount;
                    String[] aliasArray = line.split("\\\\");
                    String alias = "";
                    for (int i = 0; i < aliasArray.length; ++i) {
                        alias = alias + aliasArray[i];
                    }
                    IAtom aliasAtom = outputContainer.getAtom(aliasAtomNumber);
                    IAtom newPseudoAtom = molecule.getBuilder().newInstance(IPseudoAtom.class, alias);
                    if (aliasAtom.getPoint2d() != null) {
                        newPseudoAtom.setPoint2d(aliasAtom.getPoint2d());
                    }
                    if (aliasAtom.getPoint3d() != null) {
                        newPseudoAtom.setPoint3d(aliasAtom.getPoint3d());
                    }
                    outputContainer.addAtom(newPseudoAtom);
                    List<IBond> bondsOfAliasAtom = outputContainer.getConnectedBondsList(aliasAtom);
                    for (int i = 0; i < bondsOfAliasAtom.size(); ++i) {
                        IBond bondOfAliasAtom = bondsOfAliasAtom.get(i);
                        IAtom connectedToAliasAtom = bondOfAliasAtom.getConnectedAtom(aliasAtom);
                        IBond newBond = bondOfAliasAtom.getBuilder().newInstance(IBond.class, new Object[0]);
                        newBond.setAtoms(new IAtom[]{connectedToAliasAtom, newPseudoAtom});
                        newBond.setOrder(bondOfAliasAtom.getOrder());
                        outputContainer.addBond(newBond);
                        outputContainer.removeBond(aliasAtom, connectedToAliasAtom);
                    }
                    outputContainer.removeAtom(aliasAtom);
                    ++RGroupCounter;
                } else if (line.startsWith("M  ISO")) {
                    try {
                        String countString = line.substring(6, 10).trim();
                        int infoCount = Integer.parseInt(countString);
                        StringTokenizer st = new StringTokenizer(line.substring(10));
                        for (int i = 1; i <= infoCount; ++i) {
                            int atomNumber = Integer.parseInt(st.nextToken().trim());
                            int absMass = Integer.parseInt(st.nextToken().trim());
                            if (absMass == 0) continue;
                            IAtom isotope = outputContainer.getAtom(atomNumber - 1);
                            isotope.setMassNumber(absMass);
                        }
                    }
                    catch (NumberFormatException exception) {
                        String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                        logger.error(error);
                        this.handleError("NumberFormatException in isotope information.", linecount, 7, 11, exception);
                    }
                } else if (line.startsWith("M  RAD")) {
                    try {
                        String countString = line.substring(6, 9).trim();
                        int infoCount = Integer.parseInt(countString);
                        StringTokenizer st = new StringTokenizer(line.substring(9));
                        for (int i = 1; i <= infoCount; ++i) {
                            int atomNumber = Integer.parseInt(st.nextToken().trim());
                            int spinMultiplicity = Integer.parseInt(st.nextToken().trim());
                            if (spinMultiplicity <= 1) continue;
                            IAtom radical = outputContainer.getAtom(atomNumber - 1);
                            for (int j = 2; j <= spinMultiplicity; ++j) {
                                outputContainer.addSingleElectron(molecule.getBuilder().newInstance(ISingleElectron.class, radical));
                            }
                        }
                    }
                    catch (NumberFormatException exception) {
                        String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                        logger.error(error);
                        this.handleError("NumberFormatException in radical information", linecount, 7, 10, exception);
                    }
                } else if (line.startsWith("G  ")) {
                    try {
                        String atomNumberString = line.substring(3, 6).trim();
                        int atomNumber = Integer.parseInt(atomNumberString);
                        String atomName = this.input.readLine();
                        IAtom prevAtom = outputContainer.getAtom(atomNumber - 1);
                        IPseudoAtom pseudoAtom = molecule.getBuilder().newInstance(IPseudoAtom.class, atomName);
                        if (prevAtom.getPoint2d() != null) {
                            pseudoAtom.setPoint2d(prevAtom.getPoint2d());
                        }
                        if (prevAtom.getPoint3d() != null) {
                            pseudoAtom.setPoint3d(prevAtom.getPoint3d());
                        }
                        AtomContainerManipulator.replaceAtomByAtom(molecule, prevAtom, pseudoAtom);
                    }
                    catch (NumberFormatException exception) {
                        String error = "Error (" + exception.toString() + ") while parsing line " + linecount + ": " + line + " in property block.";
                        logger.error(error);
                        this.handleError("NumberFormatException in group information", linecount, 4, 7, exception);
                    }
                } else if (line.startsWith("M  RGP")) {
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    while (st.hasMoreTokens()) {
                        Integer position = new Integer(st.nextToken());
                        Rnumber = new Integer(st.nextToken());
                        IPseudoAtom pseudoAtom = (IPseudoAtom)rAtoms.get(position);
                        if (pseudoAtom == null) continue;
                        pseudoAtom.setLabel("R" + Rnumber);
                    }
                }
                if (line.startsWith("V  ")) {
                    Integer atomNumber = new Integer(line.substring(3, 6).trim());
                    IAtom atomWithComment = outputContainer.getAtom(atomNumber - 1);
                    atomWithComment.setProperty("cdk:Comment", line.substring(7));
                }
                if (lineRead) continue;
                logger.warn("Skipping line in property block: ", line);
            }
            if (this.interpretHydrogenIsotopes.isSet()) {
                this.fixHydrogenIsotopes(molecule, isotopeFactory);
            }
        }
        catch (CDKException exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw exception;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            this.handleError("Error while parsing line: " + line, linecount, 0, 0, exception);
        }
        return outputContainer;
    }

    private void fixHydrogenIsotopes(IAtomContainer molecule, IsotopeFactory isotopeFactory) {
        for (IAtom atom : molecule.atoms()) {
            IIsotope isotope;
            IAtom newAtom;
            if (!(atom instanceof IPseudoAtom)) continue;
            IPseudoAtom pseudo = (IPseudoAtom)atom;
            if ("D".equals(pseudo.getLabel())) {
                newAtom = molecule.getBuilder().newInstance(IAtom.class, atom);
                newAtom.setSymbol("H");
                isotope = molecule.getBuilder().newInstance(IIsotope.class, "H", 2);
                isotopeFactory.configure(newAtom, isotope);
                AtomContainerManipulator.replaceAtomByAtom(molecule, atom, newAtom);
                continue;
            }
            if (!"T".equals(pseudo.getLabel())) continue;
            newAtom = molecule.getBuilder().newInstance(IAtom.class, atom);
            newAtom.setSymbol("H");
            isotope = molecule.getBuilder().newInstance(IIsotope.class, "H", 3);
            isotopeFactory.configure(newAtom, isotope);
            AtomContainerManipulator.replaceAtomByAtom(molecule, atom, newAtom);
        }
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", 2, "Should coordinates always be read as 3D?", "false");
        this.interpretHydrogenIsotopes = new BooleanIOSetting("InterpretHydrogenIsotopes", 2, "Should D and T be interpreted as hydrogen isotopes?", "true");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
        this.fireIOSettingQuestion(this.interpretHydrogenIsotopes);
    }

    @Override
    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.forceReadAs3DCoords, this.interpretHydrogenIsotopes};
        return settings;
    }

    public List<IAtom> getAtomsByLinePosition() {
        return this.atomsByLinePosition;
    }

    private String removeNonDigits(String input) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char inputChar = input.charAt(i);
            if (!Character.isDigit(inputChar)) continue;
            buffer.append(inputChar);
        }
        return buffer.toString();
    }
}

