/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.type.AdductionSodiumLPReactionTest")
public class AdductionSodiumLPReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AdductionSodiumLPReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#AdductionSodiumLP", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IAtomContainerSet_IAtomContainerSet")
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: AdductionSodiumLPReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("AdductionSodiumLPReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("AdductionSodiumLPReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        if (AtomContainerManipulator.getTotalCharge(reactant) > 0.0) {
            return setOfReactions;
        }
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(10) || (atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) > 0 || reactant.getConnectedLonePairsCount(atomi) <= 0 || reactant.getConnectedSingleElectronsCount(atomi) != 0) continue;
            ArrayList<IAtom> atomList = new ArrayList<IAtom>();
            atomList.add(atomi);
            IAtom atomH = reactant.getBuilder().newInstance(IAtom.class, "Na");
            atomH.setFormalCharge(1);
            atomList.add(atomH);
            IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            moleculeSet.addAtomContainer(reactant);
            IAtomContainer adduct = reactant.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            adduct.addAtom(atomH);
            moleculeSet.addAtomContainer(adduct);
            IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, null);
            if (reaction == null) continue;
            setOfReactions.addReaction(reaction);
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        if (AtomContainerManipulator.getTotalCharge(reactant) > 0.0) {
            return;
        }
        for (IAtom atomi : reactant.atoms()) {
            if ((atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) > 0 || reactant.getConnectedLonePairsCount(atomi) <= 0 || reactant.getConnectedSingleElectronsCount(atomi) != 0) continue;
            atomi.setFlag(10, true);
        }
    }
}

