/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Range;
import org.xmlcml.euclid.RealArray;

public class Real2Array
implements EuclidConstants {
    RealArray xarr;
    RealArray yarr;
    int nelem = 0;

    public Real2Array() {
    }

    public Real2Range getRange2() {
        Real2Range range = new Real2Range();
        for (int i = 0; i < this.nelem; ++i) {
            Real2 r2 = new Real2(this.xarr.elementAt(i), this.yarr.elementAt(i));
            range.add(r2);
        }
        return range;
    }

    public Real2Array(RealArray x, RealArray y) throws EuclidRuntimeException {
        if (x.size() != y.size()) {
            throw new EuclidRuntimeException("incompatible array sizes " + x.size() + "/" + y.size());
        }
        this.nelem = x.size();
        this.xarr = (RealArray)x.clone();
        this.yarr = (RealArray)y.clone();
    }

    public void add(Real2 r2) {
        if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
            this.xarr = new RealArray();
            this.yarr = new RealArray();
        }
        this.xarr.addElement(r2.getX());
        this.yarr.addElement(r2.getY());
        ++this.nelem;
    }

    public void add(Real2Array real2Array) {
        if (this.nelem == 0 || this.xarr == null || this.yarr == null) {
            this.xarr = new RealArray();
            this.yarr = new RealArray();
        }
        this.xarr.addArray(real2Array.xarr);
        this.yarr.addArray(real2Array.yarr);
        this.nelem += real2Array.size();
    }

    public static Real2Array createFromPairs(String sss, String delimiter) {
        String[] ss = sss.split(" ");
        Real2Array real2Array = new Real2Array();
        real2Array.xarr = new RealArray();
        real2Array.yarr = new RealArray();
        for (String s : ss) {
            Real2 r2 = new Real2(s, delimiter);
            if (r2 == null) {
                throw new RuntimeException("bad real2: " + s);
            }
            real2Array.xarr.addElement(r2.getX());
            real2Array.yarr.addElement(r2.getY());
            ++real2Array.nelem;
        }
        return real2Array;
    }

    public RealArray getXArray() {
        return this.xarr;
    }

    public RealArray getYArray() {
        return this.yarr;
    }

    public int size() {
        return this.nelem;
    }

    public Real2 elementAt(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public Real2 get(int elem) {
        return new Real2(this.xarr.elementAt(elem), this.yarr.elementAt(elem));
    }

    public void deleteElement(int i) {
        if (i >= 0 && i < this.nelem) {
            this.xarr.deleteElement(i);
            this.yarr.deleteElement(i);
            --this.nelem;
        } else {
            throw new EuclidRuntimeException("Cannt delete element at: " + i);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        double[] xarray = this.xarr == null ? null : this.xarr.getArray();
        double[] yarray = this.yarr == null ? null : this.yarr.getArray();
        s.append("(");
        for (int i = 0; i < this.nelem; ++i) {
            s.append("(");
            s.append(xarray[i]);
            s.append(",");
            s.append(yarray[i]);
            s.append(")");
        }
        s.append(")");
        return s.toString();
    }
}

