/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.xml.sax.Attributes;

public class CMLReactionModule
extends CMLCoreModule {
    private String objectType;

    public CMLReactionModule(IChemFile chemFile) {
        super(chemFile);
    }

    public CMLReactionModule(ICMLModule conv) {
        super(conv);
        this.logger.debug("New CML-Reaction Module!");
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        if ("reaction".equals(local)) {
            if (this.currentReactionSet == null) {
                this.currentReactionSet = this.currentChemFile.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            }
            this.currentReaction = this.currentChemFile.getBuilder().newInstance(IReaction.class, new Object[0]);
            String id = atts.getValue("id");
            if (id != null) {
                this.currentReaction.setID(id);
            }
        } else if ("reactionList".equals(local)) {
            this.currentReactionSet = this.currentChemFile.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            String id = atts.getValue("id");
            if (id != null) {
                this.currentReactionSet.setID(id);
            }
        } else if ("reactant".equals(local)) {
            if (this.currentReaction == null) {
                if (this.currentReactionSet == null) {
                    this.currentReactionSet = this.currentChemFile.getBuilder().newInstance(IReactionSet.class, new Object[0]);
                }
                this.currentReaction = this.currentChemFile.getBuilder().newInstance(IReaction.class, new Object[0]);
            }
            this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            this.objectType = "Reactant";
            String id = atts.getValue("id");
            if (id != null) {
                this.currentMolecule.setID(id);
            } else {
                String ref = atts.getValue("ref");
                if (ref != null) {
                    this.currentMolecule.setID(ref);
                }
            }
        } else if ("product".equals(local)) {
            if (this.currentReaction == null) {
                if (this.currentReactionSet == null) {
                    this.currentReactionSet = this.currentChemFile.getBuilder().newInstance(IReactionSet.class, new Object[0]);
                }
                this.currentReaction = this.currentChemFile.getBuilder().newInstance(IReaction.class, new Object[0]);
            }
            this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            this.objectType = "Product";
            String id = atts.getValue("id");
            if (id != null) {
                this.currentMolecule.setID(id);
            } else {
                String ref = atts.getValue("ref");
                if (ref != null) {
                    this.currentMolecule.setID(ref);
                }
            }
        } else if ("substance".equals(local)) {
            if (this.currentReaction == null) {
                if (this.currentReactionSet == null) {
                    this.currentReactionSet = this.currentChemFile.getBuilder().newInstance(IReactionSet.class, new Object[0]);
                }
                this.currentReaction = this.currentChemFile.getBuilder().newInstance(IReaction.class, new Object[0]);
            }
            this.currentMolecule = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            this.objectType = "Agent";
            String id = atts.getValue("id");
            if (id != null) {
                this.currentMolecule.setID(id);
            } else {
                String ref = atts.getValue("ref");
                if (ref != null) {
                    this.currentMolecule.setID(ref);
                }
            }
        } else if ("molecule".equals(local)) {
            super.newMolecule();
            String id = atts.getValue("id");
            if (id != null) {
                IAtomContainer existing = this.getMoleculeFromID(this.currentMoleculeSet, id);
                if (existing != null) {
                    this.currentMolecule = existing;
                } else {
                    this.currentMolecule.setID(id);
                }
            } else {
                String ref = atts.getValue("ref");
                if (ref != null) {
                    IAtomContainer atomC = this.getMoleculeFromID(this.currentMoleculeSet, ref);
                    if (atomC == null) {
                        atomC = this.currentChemFile.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                        atomC.setID(ref);
                        this.currentMoleculeSet.addAtomContainer(atomC);
                    }
                    this.currentMolecule = atomC;
                }
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        if ("reaction".equals(local)) {
            this.currentReactionSet.addReaction(this.currentReaction);
        } else if ("reactionList".equals(local)) {
            this.currentChemModel.setReactionSet(this.currentReactionSet);
            this.currentChemSequence.addChemModel(this.currentChemModel);
        } else if ("reactant".equals(local)) {
            this.currentReaction.addReactant(this.currentMolecule);
        } else if ("product".equals(local)) {
            this.currentReaction.addProduct(this.currentMolecule);
        } else if ("substance".equals(local)) {
            this.currentReaction.addAgent(this.currentMolecule);
        } else if ("molecule".equals(local)) {
            this.logger.debug("Storing Molecule");
            if (this.currentMoleculeSet.getMultiplier(this.currentMolecule) == -1.0) {
                super.storeData();
            }
        } else {
            super.endElement(xpath, uri, local, raw);
        }
    }

    private IAtomContainer getMoleculeFromID(IAtomContainerSet molSet, String id) {
        for (IAtomContainer mol : molSet.atomContainers()) {
            if (!mol.getID().equals(id)) continue;
            return mol;
        }
        return null;
    }
}

