/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class IsProtonInAromaticSystemDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] NAMES = new String[]{"protonInArmaticSystem"};
    private boolean checkAromaticity = false;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#isProtonInAromaticSystem", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("IsProtonInAromaticSystemDescriptor only expects two parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer) {
        IAtomContainer clonedAtomContainer;
        try {
            clonedAtomContainer = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), NAMES, e);
        }
        IAtom clonedAtom = clonedAtomContainer.getAtom(atomContainer.indexOf(atom));
        int isProtonInAromaticSystem = 0;
        IAtomContainer mol = atom.getBuilder().newInstance(IAtomContainer.class, clonedAtomContainer);
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
                Aromaticity.cdkLegacy().apply(mol);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), NAMES, e);
            }
        }
        List<IAtom> neighboor = mol.getConnectedAtomsList(clonedAtom);
        IAtom neighbour0 = neighboor.get(0);
        if (atom.getSymbol().equals("H")) {
            if (neighbour0.getFlag(32)) {
                isProtonInAromaticSystem = 1;
            } else {
                List<IAtom> betaAtoms = clonedAtomContainer.getConnectedAtomsList(neighbour0);
                for (IAtom betaAtom : betaAtoms) {
                    if (betaAtom.getFlag(32)) {
                        isProtonInAromaticSystem = 2;
                        continue;
                    }
                    isProtonInAromaticSystem = 0;
                }
            }
        } else {
            isProtonInAromaticSystem = 0;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(isProtonInAromaticSystem), NAMES);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }
}

