/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.openscience.cdk.tools.ILoggingTool;

public class SystemOutLoggingTool
implements ILoggingTool {
    private boolean doDebug = false;
    private static ILoggingTool logger;
    private String classname;
    private int stackLength;

    public SystemOutLoggingTool(Class<?> classInst) {
        this.classname = classInst.getName();
        this.doDebug = false;
        if (System.getProperty("cdk.debugging", "false").equals("true") || System.getProperty("cdk.debug.stdout", "false").equals("true")) {
            this.doDebug = true;
        }
    }

    @Override
    public void dumpSystemProperties() {
        this.debug("os.name        : " + System.getProperty("os.name"));
        this.debug("os.version     : " + System.getProperty("os.version"));
        this.debug("os.arch        : " + System.getProperty("os.arch"));
        this.debug("java.version   : " + System.getProperty("java.version"));
        this.debug("java.vendor    : " + System.getProperty("java.vendor"));
    }

    @Override
    public void setStackLength(int length) {
        this.stackLength = length;
    }

    @Override
    public void dumpClasspath() {
        this.debug("java.class.path: " + System.getProperty("java.class.path"));
    }

    @Override
    public void debug(Object object) {
        if (this.doDebug) {
            if (object instanceof Throwable) {
                this.debugThrowable((Throwable)object);
            } else {
                this.debugString("" + object);
            }
        }
    }

    private void debugString(String string) {
        this.printToSTDOUT("DEBUG", string);
    }

    @Override
    public void debug(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                if (obj == null) {
                    result.append("null");
                    continue;
                }
                result.append(obj.toString());
            }
            this.debugString(result.toString());
        }
    }

    private void debugThrowable(Throwable problem) {
        if (problem != null) {
            if (problem instanceof Error) {
                this.debug("Error: ", problem.getMessage());
            } else {
                this.debug("Exception: ", problem.getMessage());
            }
            StringWriter stackTraceWriter = new StringWriter();
            problem.printStackTrace(new PrintWriter(stackTraceWriter));
            String trace = stackTraceWriter.toString();
            try {
                BufferedReader reader = new BufferedReader(new StringReader(trace));
                if (reader.ready()) {
                    String traceLine = reader.readLine();
                    for (int counter = 0; reader.ready() && traceLine != null && counter < this.stackLength; ++counter) {
                        this.debug(traceLine);
                        traceLine = reader.readLine();
                    }
                }
            }
            catch (Exception ioException) {
                this.error("Serious error in LoggingTool while printing exception stack trace: ", ioException.getMessage());
                logger.debug(ioException);
            }
            Throwable cause = problem.getCause();
            if (cause != null) {
                this.debug("Caused by: ");
                this.debugThrowable(cause);
            }
        }
    }

    @Override
    public void error(Object object) {
        if (this.doDebug) {
            this.errorString("" + object);
        }
    }

    @Override
    public void error(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.errorString(result.toString());
        }
    }

    private void errorString(String string) {
        this.printToSTDOUT("ERROR", string);
    }

    @Override
    public void fatal(Object object) {
        if (this.doDebug) {
            this.printToSTDOUT("FATAL", object.toString());
        }
    }

    @Override
    public void info(Object object) {
        if (this.doDebug) {
            this.infoString("" + object);
        }
    }

    @Override
    public void info(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.infoString(result.toString());
        }
    }

    private void infoString(String string) {
        this.printToSTDOUT("INFO", string);
    }

    @Override
    public void warn(Object object) {
        if (this.doDebug) {
            this.warnString("" + object);
        }
    }

    private void warnString(String string) {
        this.printToSTDOUT("WARN", string);
    }

    @Override
    public void warn(Object object, Object ... objects) {
        if (this.doDebug) {
            StringBuilder result = new StringBuilder();
            result.append(object.toString());
            for (Object obj : objects) {
                result.append(obj.toString());
            }
            this.warnString(result.toString());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.doDebug;
    }

    private void printToSTDOUT(String level, String message) {
        System.out.print(this.classname);
        System.out.print(" ");
        System.out.print(level);
        System.out.print(": ");
        System.out.println(message);
    }

    public static ILoggingTool create(Class<?> sourceClass) {
        return new SystemOutLoggingTool(sourceClass);
    }

    protected void setDebugEnabled(boolean enabled) {
        this.doDebug = enabled;
    }
}

