/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import java.util.BitSet;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.Matching;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public final class Kekulization {
    public static void kekulize(IAtomContainer ac) throws CDKException {
        BitSet available;
        Matching matching = Matching.withCapacity(ac.getAtomCount());
        IAtom[] atoms = AtomContainerManipulator.getAtomArray(ac);
        GraphUtil.EdgeToBondMap bonds = GraphUtil.EdgeToBondMap.withSpaceFor(ac);
        int[][] graph = GraphUtil.toAdjList(ac, bonds);
        if (!matching.perfect(graph, available = Kekulization.available(graph, atoms, bonds))) {
            throw new CDKException("Cannot assign Kekul\u00e9 structure without randomly creating radicals.");
        }
        for (IBond bond : ac.bonds()) {
            if (bond.getOrder() != IBond.Order.UNSET || !bond.isAromatic()) continue;
            bond.setOrder(IBond.Order.SINGLE);
        }
        int v = available.nextSetBit(0);
        while (v >= 0) {
            int w = matching.other(v);
            IBond bond = bonds.get(v, w);
            if (bond.getOrder().numeric() > 1) {
                throw new CDKException("Cannot assign Kekul\u00e9 structure, non-sigma bond order has already been assigned?");
            }
            bond.setOrder(IBond.Order.DOUBLE);
            available.clear(w);
            v = available.nextSetBit(v + 1);
        }
    }

    private static BitSet available(int[][] graph, IAtom[] atoms, GraphUtil.EdgeToBondMap bonds) {
        BitSet available = new BitSet();
        block0: for (int i = 0; i < atoms.length; ++i) {
            int valence;
            int charge;
            IAtom atom = atoms[i];
            if (atom.getAtomicNumber() == null) {
                throw new IllegalArgumentException("atom " + (i + 1) + " had unset atomic number");
            }
            if (atom.getFormalCharge() == null) {
                throw new IllegalArgumentException("atom " + (i + 1) + " had unset formal charge");
            }
            if (atom.getImplicitHydrogenCount() == null) {
                throw new IllegalArgumentException("atom " + (i + 1) + " had unset implicit hydrogen count");
            }
            if (!atom.getFlag(32)) continue;
            int nPiBonds = 0;
            for (int w : graph[i]) {
                IBond.Order order = bonds.get(i, w).getOrder();
                if (order == IBond.Order.DOUBLE) {
                    ++nPiBonds;
                    continue;
                }
                if (order.numeric() > 2) continue block0;
            }
            int element = atom.getAtomicNumber();
            if (!Kekulization.available(element, charge = atom.getFormalCharge().intValue(), valence = graph[i].length + atom.getImplicitHydrogenCount() + nPiBonds)) continue;
            available.set(i);
        }
        return available;
    }

    private static boolean available(int element, int charge, int valence) {
        switch (Elements.ofNumber(element)) {
            case Boron: {
                if (charge == 0 && valence <= 2) {
                    return true;
                }
                if (charge != -1 || valence > 3) break;
                return true;
            }
            case Carbon: 
            case Silicon: 
            case Germanium: 
            case Tin: {
                if (charge != 0 || valence > 3) break;
                return true;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                if (charge == 0) {
                    return valence <= 2 || valence == 4;
                }
                if (charge != 1) break;
                return valence <= 3;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                if (charge == 0) {
                    return valence <= 1 || valence == 3 || valence == 5;
                }
                if (charge != 1) break;
                return valence <= 2 || valence == 4;
            }
        }
        return false;
    }
}

