/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.formula.rules.ChargeRule;
import org.openscience.cdk.formula.rules.ElementRule;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.formula.rules.ToleranceRangeRule;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import org.openscience.cdk.tools.manipulator.MolecularFormulaRangeManipulator;

@Deprecated
public class MassToFormulaTool {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(MassToFormulaTool.class);
    private IChemObjectBuilder builder;
    AtomTypeFactory factory;
    private int[][] matrix_Base;
    private String[] orderElements;
    private List<IRule> rules;
    private MolecularFormulaRange mfRange;
    private Double charge;
    private Double tolerance;

    public MassToFormulaTool(IChemObjectBuilder builder) {
        this.builder = builder;
        this.logger.info("Initiate MassToForumlaTool");
        this.factory = AtomTypeFactory.getInstance(builder);
        this.orderElements = this.generateOrderE();
        this.setDefaultRestrictions();
    }

    public void setRestrictions(List<IRule> rulesNew) throws CDKException {
        block0: for (IRule rule : rulesNew) {
            if (rule instanceof ElementRule) {
                this.mfRange = (MolecularFormulaRange)rule.getParameters()[0];
                for (IRule oldRule : this.rules) {
                    if (!(oldRule instanceof ElementRule)) continue;
                    this.rules.remove(oldRule);
                    this.rules.add(rule);
                    break;
                }
                this.matrix_Base = this.getMatrix(this.mfRange.getIsotopeCount());
                continue;
            }
            if (rule instanceof ChargeRule) {
                this.charge = (Double)rule.getParameters()[0];
                for (IRule oldRule : this.rules) {
                    if (!(oldRule instanceof ChargeRule)) continue;
                    this.rules.remove(oldRule);
                    this.rules.add(rule);
                    continue block0;
                }
                continue;
            }
            if (rule instanceof ToleranceRangeRule) {
                this.tolerance = (Double)rule.getParameters()[1];
                for (IRule oldRule : this.rules) {
                    if (!(oldRule instanceof ToleranceRangeRule)) continue;
                    this.rules.remove(oldRule);
                    this.rules.add(rule);
                    continue block0;
                }
                continue;
            }
            this.rules.add(rule);
        }
    }

    public List<IRule> getRestrictions() {
        return this.rules;
    }

    public void setDefaultRestrictions() {
        try {
            this.callDefaultRestrictions();
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void callDefaultRestrictions() throws CDKException, IOException {
        ArrayList<IRule> rules1 = new ArrayList<IRule>();
        Isotopes ifac = Isotopes.getInstance();
        MolecularFormulaRange mfRange1 = new MolecularFormulaRange();
        mfRange1.addIsotope(ifac.getMajorIsotope("C"), 0, 15);
        mfRange1.addIsotope(ifac.getMajorIsotope("H"), 0, 15);
        mfRange1.addIsotope(ifac.getMajorIsotope("N"), 0, 15);
        mfRange1.addIsotope(ifac.getMajorIsotope("O"), 0, 15);
        IRule rule = new ElementRule();
        Object[] params = new Object[]{mfRange1};
        rule.setParameters(params);
        rules1.add(rule);
        rule = new ChargeRule();
        rules1.add(rule);
        this.charge = (Double)rule.getParameters()[0];
        rule = new ToleranceRangeRule();
        rules1.add(rule);
        this.tolerance = (Double)rule.getParameters()[1];
        this.matrix_Base = this.getMatrix(mfRange1.getIsotopeCount());
        this.mfRange = mfRange1;
        this.rules = rules1;
    }

    public IMolecularFormulaSet generate(double mass) {
        if (mass <= 0.0) {
            this.logger.error("Proposed mass is not valid: ", mass);
            return null;
        }
        IMolecularFormula minimalMF = MolecularFormulaRangeManipulator.getMinimalFormula(this.mfRange, this.builder);
        IMolecularFormula maximalMF = MolecularFormulaRangeManipulator.getMaximalFormula(this.mfRange, this.builder);
        double massMim = MolecularFormulaManipulator.getTotalExactMass(minimalMF) - this.tolerance;
        double massMap = MolecularFormulaManipulator.getTotalExactMass(maximalMF) + this.tolerance;
        if (massMim > mass || massMap < mass) {
            this.logger.error("Proposed mass is out of the range: ", mass);
            return null;
        }
        IMolecularFormulaSet molecularFormulaSet = this.builder.newInstance(IMolecularFormulaSet.class, new Object[0]);
        int[][] matrix = this.matrix_Base;
        int numberElements = this.mfRange.getIsotopeCount();
        List<IIsotope> isotopes_TO = new ArrayList<IIsotope>();
        Iterator<IIsotope> isIt = this.mfRange.isotopes().iterator();
        while (isIt.hasNext()) {
            isotopes_TO.add(isIt.next());
        }
        isotopes_TO = this.orderList(isotopes_TO);
        block1: for (int i = 0; i < matrix.length; ++i) {
            int[] value_In = new int[numberElements];
            for (int j = 0; j < numberElements; ++j) {
                value_In[j] = matrix[i][j] == 0 ? 0 : 1;
            }
            int count_E = 0;
            ArrayList<Integer> elem_Pos = new ArrayList<Integer>();
            for (int j = 0; j < matrix[1].length; ++j) {
                if (value_In[j] == 0) continue;
                ++count_E;
                elem_Pos.add(j);
            }
            boolean flag = true;
            int possChan = 0;
            String lastMFString = "";
            while (flag) {
                IMolecularFormula myMF;
                String newMFString;
                int occurence;
                boolean flagBreak = false;
                for (int j = 0; j < matrix[1].length; ++j) {
                    int min = this.mfRange.getIsotopeCountMin(isotopes_TO.get(j));
                    if (value_In[j] != 0 || min == 0) continue;
                    flagBreak = true;
                }
                if (flagBreak || (occurence = this.getMaxOccurence(mass, (Integer)elem_Pos.get(possChan), value_In, isotopes_TO)) == 0) continue block1;
                int maxx = this.mfRange.getIsotopeCountMax(isotopes_TO.get((Integer)elem_Pos.get(possChan)));
                int minn = this.mfRange.getIsotopeCountMin(isotopes_TO.get((Integer)elem_Pos.get(possChan)));
                if (occurence < minn | maxx < occurence) {
                    if (possChan < elem_Pos.size() - 1) {
                        if (maxx < occurence) {
                            value_In[((Integer)elem_Pos.get((int)possChan)).intValue()] = maxx;
                        }
                        ++possChan;
                        continue;
                    }
                    boolean foundZ = false;
                    for (int z = possChan - 1; z >= 0; --z) {
                        int newValue;
                        if (value_In[(Integer)elem_Pos.get(z)] == 1) continue;
                        possChan = z;
                        foundZ = true;
                        value_In[((Integer)elem_Pos.get((int)possChan)).intValue()] = newValue = value_In[(Integer)elem_Pos.get(possChan)] - 1;
                        for (int j = possChan + 1; j < elem_Pos.size(); ++j) {
                            int p = (Integer)elem_Pos.get(j);
                            value_In[p] = 1;
                        }
                        ++possChan;
                        break;
                    }
                    if (foundZ) continue;
                    continue block1;
                }
                value_In[((Integer)elem_Pos.get((int)possChan)).intValue()] = occurence;
                double massT = this.calculateMassT(isotopes_TO, value_In);
                double diff_new = Math.abs(mass - massT);
                if (diff_new < this.tolerance && !(newMFString = MolecularFormulaManipulator.getString(myMF = this.getFormula(isotopes_TO, value_In))).equals(lastMFString)) {
                    molecularFormulaSet.addMolecularFormula(myMF);
                    lastMFString = newMFString;
                }
                if (count_E == 1) continue block1;
                if (possChan < elem_Pos.size() - 1) {
                    ++possChan;
                    continue;
                }
                boolean foundZ = false;
                for (int z = possChan - 1; z >= 0; --z) {
                    int newValue;
                    if (value_In[(Integer)elem_Pos.get(z)] == 1) continue;
                    possChan = z;
                    foundZ = true;
                    value_In[((Integer)elem_Pos.get((int)possChan)).intValue()] = newValue = value_In[(Integer)elem_Pos.get(possChan)] - 1;
                    for (int j = possChan + 1; j < elem_Pos.size(); ++j) {
                        int p = (Integer)elem_Pos.get(j);
                        value_In[p] = 1;
                    }
                    ++possChan;
                    break;
                }
                if (foundZ) continue;
                continue block1;
            }
        }
        return this.returnOrdered(mass, molecularFormulaSet);
    }

    private List<IIsotope> orderList(List<IIsotope> isotopes_TO) {
        ArrayList<IIsotope> newOrderList = new ArrayList<IIsotope>();
        for (int i = 0; i < this.orderElements.length; ++i) {
            String symbol = this.orderElements[i];
            for (IIsotope isotopeToCo : isotopes_TO) {
                if (!isotopeToCo.getSymbol().equals(symbol)) continue;
                newOrderList.add(isotopeToCo);
            }
        }
        return newOrderList;
    }

    private String[] generateOrderE() {
        String[] listElements = new String[]{"C", "H", "O", "N", "Si", "P", "S", "F", "Cl", "Br", "I", "Sn", "B", "Pb", "Tl", "Ba", "In", "Pd", "Pt", "Os", "Ag", "Zr", "Se", "Zn", "Cu", "Ni", "Co", "Fe", "Cr", "Ti", "Ca", "K", "Al", "Mg", "Na", "Ce", "Hg", "Au", "Ir", "Re", "W", "Ta", "Hf", "Lu", "Yb", "Tm", "Er", "Ho", "Dy", "Tb", "Gd", "Eu", "Sm", "Pm", "Nd", "Pr", "La", "Cs", "Xe", "Te", "Sb", "Cd", "Rh", "Ru", "Tc", "Mo", "Nb", "Y", "Sr", "Rb", "Kr", "As", "Ge", "Ga", "Mn", "V", "Sc", "Ar", "Ne", "Be", "Li", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu"};
        return listElements;
    }

    private int getMaxOccurence(double massTo, int element_pos, int[] matrix, List<IIsotope> isoToCond_new) {
        double massIn = isoToCond_new.get(element_pos).getExactMass();
        double massToM = massTo;
        for (int i = 0; i < matrix.length; ++i) {
            if (i == element_pos || matrix[i] == 0) continue;
            massToM -= isoToCond_new.get(i).getExactMass() * (double)matrix[i];
        }
        int value = (int)((massToM + 1.0) / massIn);
        return value;
    }

    private IMolecularFormula getFormula(List<IIsotope> isoToCond_new, int[] value_In) {
        IMolecularFormula mf = this.builder.newInstance(IMolecularFormula.class, new Object[0]);
        for (int i = 0; i < isoToCond_new.size(); ++i) {
            if (value_In[i] == 0) continue;
            for (int j = 0; j < value_In[i]; ++j) {
                mf.addIsotope(isoToCond_new.get(i));
            }
        }
        mf = this.putInOrder(mf);
        return mf;
    }

    private IMolecularFormula putInOrder(IMolecularFormula formula) {
        IMolecularFormula new_formula = formula.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        for (int i = 0; i < this.orderElements.length; ++i) {
            IElement element = this.builder.newInstance(IElement.class, this.orderElements[i]);
            if (!MolecularFormulaManipulator.containsElement(formula, element)) continue;
            for (IIsotope isotope : MolecularFormulaManipulator.getIsotopes(formula, element)) {
                new_formula.addIsotope(isotope, formula.getIsotopeCount(isotope));
            }
        }
        return new_formula;
    }

    private double calculateMassT(List<IIsotope> isoToCond_new, int[] value_In) {
        double result = 0.0;
        for (int i = 0; i < isoToCond_new.size(); ++i) {
            if (value_In[i] == 0) continue;
            result += isoToCond_new.get(i).getExactMass() * (double)value_In[i];
        }
        return result;
    }

    private IMolecularFormulaSet returnOrdered(double mass, IMolecularFormulaSet formulaSet) {
        IMolecularFormulaSet solutions_new = null;
        if (formulaSet.size() != 0) {
            double valueMin = 100.0;
            int i_final = 0;
            solutions_new = formulaSet.getBuilder().newInstance(IMolecularFormulaSet.class, new Object[0]);
            ArrayList<Integer> listI = new ArrayList<Integer>();
            for (int j = 0; j < formulaSet.size(); ++j) {
                for (int i = 0; i < formulaSet.size(); ++i) {
                    double value;
                    double diff;
                    if (listI.contains(i) || !(valueMin > (diff = Math.abs(mass - Math.abs(value = MolecularFormulaManipulator.getTotalExactMass(formulaSet.getMolecularFormula(i))))))) continue;
                    valueMin = diff;
                    i_final = i;
                }
                valueMin = 100.0;
                solutions_new.addMolecularFormula(formulaSet.getMolecularFormula(i_final));
                listI.add(i_final);
            }
        }
        return solutions_new;
    }

    private int[][] getMatrix(int size) {
        this.logger.info("Creating matrix for isotopes combination");
        int lengthM = (int)Math.pow(2.0, size);
        int[][] matrix = new int[--lengthM][size];
        int[] combi = new int[size];
        for (int j = 0; j < size; ++j) {
            combi[j] = 0;
        }
        int posChang = size - 1;
        int posRemov = size - 1;
        block1: for (int i = 0; i < lengthM; ++i) {
            int j;
            for (j = posRemov; j < size; ++j) {
                combi[j] = 0;
            }
            combi[posChang] = 1;
            for (j = 0; j < size; ++j) {
                matrix[i][j] = combi[j];
            }
            if (posChang == size - 1) {
                for (j = posChang; j >= 0; --j) {
                    if (combi[j] != 0) continue;
                    posChang = j;
                    posRemov = j + 1;
                    continue block1;
                }
                continue;
            }
            for (j = posChang; j < size; ++j) {
                if (combi[j] != 0) continue;
                posChang = j;
            }
        }
        return matrix;
    }
}

