/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

public final class JmolColors
implements IAtomColorer {
    private static final Color hexFFFFFF = new Color(0xFFFFFF);
    private static final Color hexD9FFFF = new Color(0xD9FFFF);
    private static final Color hexCC80FF = new Color(13402367);
    private static final Color hexC2FF00 = new Color(12779264);
    private static final Color hexFFB5B5 = new Color(0xFFB5B5);
    private static final Color hex909090 = new Color(0x909090);
    private static final Color hex3050F8 = new Color(3166456);
    private static final Color hexFF0D0D = new Color(0xFF0D0D);
    private static final Color hex90E050 = new Color(9494608);
    private static final Color hexB3E3F5 = new Color(11789301);
    private static final Color hexAB5CF2 = new Color(11230450);
    private static final Color hex8AFF00 = new Color(9109248);
    private static final Color hexBFA6A6 = new Color(12560038);
    private static final Color hexF0C8A0 = new Color(15780000);
    private static final Color hexFF8000 = new Color(0xFF8000);
    private static final Color hexFFFF30 = new Color(0xFFFF30);
    private static final Color hex1FF01F = new Color(0x1FF01F);
    private static final Color hex80D1E3 = new Color(8442339);
    private static final Color hex8F40D4 = new Color(9388244);
    private static final Color hex3DFF00 = new Color(4062976);
    private static final Color hexE6E6E6 = new Color(0xE6E6E6);
    private static final Color hexBFC2C7 = new Color(12567239);
    private static final Color hexA6A6AB = new Color(0xA6A6AB);
    private static final Color hex8A99C7 = new Color(9083335);
    private static final Color hex9C7AC7 = new Color(10255047);
    private static final Color hexE06633 = new Color(14706227);
    private static final Color hexF090A0 = new Color(15765664);
    private static final Color hex50D050 = new Color(0x50D050);
    private static final Color hexC88033 = new Color(13140019);
    private static final Color hex7D80B0 = new Color(8224944);
    private static final Color hexC28F8F = new Color(12750735);
    private static final Color hex668F8F = new Color(0x668F8F);
    private static final Color hexBD80E3 = new Color(12419299);
    private static final Color hexFFA100 = new Color(16752896);
    private static final Color hexA62929 = new Color(10889513);
    private static final Color hex5CB8D1 = new Color(6076625);
    private static final Color hex702EB0 = new Color(7351984);
    private static final Color hex00FF00 = new Color(65280);
    private static final Color hex94FFFF = new Color(0x94FFFF);
    private static final Color hex94E0E0 = new Color(9756896);
    private static final Color hex73C2C9 = new Color(7586505);
    private static final Color hex54B5B5 = new Color(0x54B5B5);
    private static final Color hex3B9E9E = new Color(3907230);
    private static final Color hex248F8F = new Color(2396047);
    private static final Color hex0A7D8C = new Color(687500);
    private static final Color hex006985 = new Color(27013);
    private static final Color hexC0C0C0 = new Color(0xC0C0C0);
    private static final Color hexFFD98F = new Color(16767375);
    private static final Color hexA67573 = new Color(10909043);
    private static final Color hex668080 = new Color(0x668080);
    private static final Color hex9E63B5 = new Color(10380213);
    private static final Color hexD47A00 = new Color(13924864);
    private static final Color hex940094 = new Color(0x940094);
    private static final Color hex429EB0 = new Color(4366000);
    private static final Color hex57178F = new Color(5707663);
    private static final Color hex00C900 = new Color(51456);
    private static final Color hex70D4FF = new Color(7394559);
    private static final Color hexFFFFC7 = new Color(0xFFFFC7);
    private static final Color hexD9FFC7 = new Color(14286791);
    private static final Color hexC7FFC7 = new Color(0xC7FFC7);
    private static final Color hexA3FFC7 = new Color(10747847);
    private static final Color hex8FFFC7 = new Color(9437127);
    private static final Color hex61FFC7 = new Color(6422471);
    private static final Color hex45FFC7 = new Color(4587463);
    private static final Color hex30FFC7 = new Color(3211207);
    private static final Color hex1FFFC7 = new Color(2097095);
    private static final Color hex00FF9C = new Color(65436);
    private static final Color hex00E675 = new Color(58997);
    private static final Color hex00D452 = new Color(54354);
    private static final Color hex00BF38 = new Color(48952);
    private static final Color hex00AB24 = new Color(43812);
    private static final Color hex4DC2FF = new Color(5096191);
    private static final Color hex4DA6FF = new Color(5089023);
    private static final Color hex2194D6 = new Color(2200790);
    private static final Color hex267DAB = new Color(2522539);
    private static final Color hex266696 = new Color(0x266696);
    private static final Color hex175487 = new Color(1528967);
    private static final Color hexD0D0E0 = new Color(0xD0D0E0);
    private static final Color hexFFD123 = new Color(16765219);
    private static final Color hexB8B8D0 = new Color(12105936);
    private static final Color hexA6544D = new Color(10900557);
    private static final Color hex575961 = new Color(5724513);
    private static final Color hex9E4FB5 = new Color(10375093);
    private static final Color hexAB5C00 = new Color(11230208);
    private static final Color hex754F45 = new Color(7688005);
    private static final Color hex428296 = new Color(4358806);
    private static final Color hex420066 = new Color(4325478);
    private static final Color hex007D00 = new Color(32000);
    private static final Color hex70ABFA = new Color(7384058);
    private static final Color hex00BAFF = new Color(47871);
    private static final Color hex00A1FF = new Color(41471);
    private static final Color hex008FFF = new Color(36863);
    private static final Color hex0080FF = new Color(33023);
    private static final Color hex006BFF = new Color(27647);
    private static final Color hex545CF2 = new Color(5528818);
    private static final Color hex785CE3 = new Color(7888099);
    private static final Color hex8A4FE3 = new Color(9064419);
    private static final Color hexA136D4 = new Color(10565332);
    private static final Color hexB31FD4 = new Color(11739092);
    private static final Color hexB31FBA = new Color(11739066);
    private static final Color hexB30DA6 = new Color(11734438);
    private static final Color hexBD0D87 = new Color(12389767);
    private static final Color hexC70066 = new Color(13041766);
    private static final Color hexCC0059 = new Color(13369433);
    private static final Color hexD1004F = new Color(13697103);
    private static final Color hexD90045 = new Color(14221381);
    private static final Color hexE00038 = new Color(14680120);
    private static final Color hexE6002E = new Color(15073326);
    private static final Color hexEB0026 = new Color(15400998);

    @Override
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, hexB31FBA);
    }

    @Override
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Elements elem = Elements.ofString(atom.getSymbol());
        if (elem == Elements.Unknown) {
            elem = Elements.ofNumber(atom.getAtomicNumber());
        }
        switch (elem) {
            case Hydrogen: {
                return hexFFFFFF;
            }
            case Helium: {
                return hexD9FFFF;
            }
            case Lithium: {
                return hexCC80FF;
            }
            case Beryllium: {
                return hexC2FF00;
            }
            case Boron: {
                return hexFFB5B5;
            }
            case Carbon: {
                return hex909090;
            }
            case Nitrogen: {
                return hex3050F8;
            }
            case Oxygen: {
                return hexFF0D0D;
            }
            case Fluorine: {
                return hex90E050;
            }
            case Neon: {
                return hexB3E3F5;
            }
            case Sodium: {
                return hexAB5CF2;
            }
            case Magnesium: {
                return hex8AFF00;
            }
            case Aluminium: {
                return hexBFA6A6;
            }
            case Silicon: {
                return hexF0C8A0;
            }
            case Phosphorus: {
                return hexFF8000;
            }
            case Sulfur: {
                return hexFFFF30;
            }
            case Chlorine: {
                return hex1FF01F;
            }
            case Argon: {
                return hex80D1E3;
            }
            case Potassium: {
                return hex8F40D4;
            }
            case Calcium: {
                return hex3DFF00;
            }
            case Scandium: {
                return hexE6E6E6;
            }
            case Titanium: {
                return hexBFC2C7;
            }
            case Vanadium: {
                return hexA6A6AB;
            }
            case Chromium: {
                return hex8A99C7;
            }
            case Manganese: {
                return hex9C7AC7;
            }
            case Iron: {
                return hexE06633;
            }
            case Cobalt: {
                return hexF090A0;
            }
            case Nickel: {
                return hex50D050;
            }
            case Copper: {
                return hexC88033;
            }
            case Zinc: {
                return hex7D80B0;
            }
            case Gallium: {
                return hexC28F8F;
            }
            case Germanium: {
                return hex668F8F;
            }
            case Arsenic: {
                return hexBD80E3;
            }
            case Selenium: {
                return hexFFA100;
            }
            case Bromine: {
                return hexA62929;
            }
            case Krypton: {
                return hex5CB8D1;
            }
            case Rubidium: {
                return hex702EB0;
            }
            case Strontium: {
                return hex00FF00;
            }
            case Yttrium: {
                return hex94FFFF;
            }
            case Zirconium: {
                return hex94E0E0;
            }
            case Niobium: {
                return hex73C2C9;
            }
            case Molybdenum: {
                return hex54B5B5;
            }
            case Technetium: {
                return hex3B9E9E;
            }
            case Ruthenium: {
                return hex248F8F;
            }
            case Rhodium: {
                return hex0A7D8C;
            }
            case Palladium: {
                return hex006985;
            }
            case Silver: {
                return hexC0C0C0;
            }
            case Cadmium: {
                return hexFFD98F;
            }
            case Indium: {
                return hexA67573;
            }
            case Tin: {
                return hex668080;
            }
            case Antimony: {
                return hex9E63B5;
            }
            case Tellurium: {
                return hexD47A00;
            }
            case Iodine: {
                return hex940094;
            }
            case Xenon: {
                return hex429EB0;
            }
            case Caesium: {
                return hex57178F;
            }
            case Barium: {
                return hex00C900;
            }
            case Lanthanum: {
                return hex70D4FF;
            }
            case Cerium: {
                return hexFFFFC7;
            }
            case Praseodymium: {
                return hexD9FFC7;
            }
            case Neodymium: {
                return hexC7FFC7;
            }
            case Promethium: {
                return hexA3FFC7;
            }
            case Samarium: {
                return hex8FFFC7;
            }
            case Europium: {
                return hex61FFC7;
            }
            case Gadolinium: {
                return hex45FFC7;
            }
            case Terbium: {
                return hex30FFC7;
            }
            case Dysprosium: {
                return hex1FFFC7;
            }
            case Holmium: {
                return hex00FF9C;
            }
            case Erbium: {
                return hex00E675;
            }
            case Thulium: {
                return hex00D452;
            }
            case Ytterbium: {
                return hex00BF38;
            }
            case Lutetium: {
                return hex00AB24;
            }
            case Hafnium: {
                return hex4DC2FF;
            }
            case Tantalum: {
                return hex4DA6FF;
            }
            case Tungsten: {
                return hex2194D6;
            }
            case Rhenium: {
                return hex267DAB;
            }
            case Osmium: {
                return hex266696;
            }
            case Iridium: {
                return hex175487;
            }
            case Platinum: {
                return hexD0D0E0;
            }
            case Gold: {
                return hexFFD123;
            }
            case Mercury: {
                return hexB8B8D0;
            }
            case Thallium: {
                return hexA6544D;
            }
            case Lead: {
                return hex575961;
            }
            case Bismuth: {
                return hex9E4FB5;
            }
            case Polonium: {
                return hexAB5C00;
            }
            case Astatine: {
                return hex754F45;
            }
            case Radon: {
                return hex428296;
            }
            case Francium: {
                return hex420066;
            }
            case Radium: {
                return hex007D00;
            }
            case Actinium: {
                return hex70ABFA;
            }
            case Thorium: {
                return hex00BAFF;
            }
            case Protactinium: {
                return hex00A1FF;
            }
            case Uranium: {
                return hex008FFF;
            }
            case Neptunium: {
                return hex0080FF;
            }
            case Plutonium: {
                return hex006BFF;
            }
            case Americium: {
                return hex545CF2;
            }
            case Curium: {
                return hex785CE3;
            }
            case Berkelium: {
                return hex8A4FE3;
            }
            case Californium: {
                return hexA136D4;
            }
            case Einsteinium: {
                return hexB31FD4;
            }
            case Fermium: {
                return hexB31FBA;
            }
            case Mendelevium: {
                return hexB30DA6;
            }
            case Nobelium: {
                return hexBD0D87;
            }
            case Lawrencium: {
                return hexC70066;
            }
            case Rutherfordium: {
                return hexCC0059;
            }
            case Dubnium: {
                return hexD1004F;
            }
            case Seaborgium: {
                return hexD90045;
            }
            case Bohrium: {
                return hexE00038;
            }
            case Hassium: {
                return hexE6002E;
            }
            case Meitnerium: {
                return hexEB0026;
            }
        }
        return defaultColor;
    }
}

