/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Attribute;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLAttribute;

public class IntSTAttribute
extends CMLAttribute {
    public static final String JAVA_TYPE = "int";
    public static final String JAVA_GET_METHOD = "getInt";
    public static final String JAVA_SHORT_CLASS = "IntSTAttribute";
    protected Integer i;

    public IntSTAttribute(String name) {
        super(name);
    }

    public IntSTAttribute(Attribute att) {
        this(att.getLocalName());
        String v = att.getValue();
        if (v != null && !v.trim().equals("")) {
            this.setCMLValue(v);
        }
    }

    public IntSTAttribute(IntSTAttribute att) {
        super(att);
        if (att.i != null) {
            this.i = new Integer(att.i);
        }
    }

    public Node copy() {
        return new IntSTAttribute(this);
    }

    public IntSTAttribute(Attribute att, String value) {
        super(att, value.trim().replace("\\s+", " "));
    }

    public void setCMLValue(String s) {
        if (s != null && !s.trim().equals("")) {
            int i;
            try {
                i = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe);
            }
            this.setCMLValue(i);
        }
    }

    public void setCMLValue(int i) {
        this.checkValue(i);
        this.i = new Integer(i);
        this.setValue("" + i);
    }

    public void checkValue(int i) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(i);
        }
    }

    public Object getCMLValue() {
        return this.i;
    }

    public int getInt() {
        if (this.i == null) {
            throw new RuntimeException("integer attribute unset");
        }
        return this.i;
    }

    public String getJavaType() {
        return JAVA_TYPE;
    }

    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

