/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.IntArrayCountFingerprint;
import org.openscience.cdk.fingerprint.IntArrayFingerprint;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.signature.AtomSignature;

public class SignatureFingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private final int signatureDepth;

    public SignatureFingerprinter() {
        this(1);
    }

    public SignatureFingerprinter(int depth) {
        this.signatureDepth = depth;
    }

    protected List<Map.Entry<String, String>> getParameters() {
        return Collections.singletonList(new AbstractMap.SimpleImmutableEntry<String, String>("signatureDepth", Integer.toString(this.signatureDepth)));
    }

    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        return new IntArrayFingerprint(this.getRawFingerprint(atomContainer));
    }

    public Map<String, Integer> getRawFingerprint(IAtomContainer atomContainer) throws CDKException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (IAtom atom : atomContainer.atoms()) {
            String signature = new AtomSignature(atom, this.signatureDepth, atomContainer).toCanonicalString();
            if (map.containsKey(signature)) {
                map.put(signature, (Integer)map.get(signature) + 1);
                continue;
            }
            map.put(signature, 1);
        }
        return map;
    }

    public int getSize() {
        return -1;
    }

    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        return new IntArrayCountFingerprint(this.getRawFingerprint(container));
    }
}

