/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcsplus.MCSPlusHandler;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKMCSHandler;
import org.openscience.cdk.smsd.algorithm.rgraph.CDKSubGraphHandler;
import org.openscience.cdk.smsd.algorithm.single.SingleMappingHandler;
import org.openscience.cdk.smsd.algorithm.vflib.VFlibMCSHandler;
import org.openscience.cdk.smsd.algorithm.vflib.VFlibSubStructureHandler;
import org.openscience.cdk.smsd.algorithm.vflib.VFlibTurboHandler;
import org.openscience.cdk.smsd.filters.ChemicalFilters;
import org.openscience.cdk.smsd.global.TimeOut;
import org.openscience.cdk.smsd.interfaces.AbstractMCS;
import org.openscience.cdk.smsd.interfaces.Algorithm;
import org.openscience.cdk.smsd.tools.MolHandler;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public final class Isomorphism
extends AbstractMCS
implements Serializable {
    static final long serialVersionUID = 10278639972837495L;
    private List<Map<Integer, Integer>> allMCS;
    private Map<Integer, Integer> firstSolution;
    private List<Map<IAtom, IAtom>> allAtomMCS;
    private Map<IAtom, IAtom> firstAtomMCS;
    private List<Map<IBond, IBond>> allBondMCS;
    private Map<IBond, IBond> firstBondMCS;
    private MolHandler rMol = null;
    private IQueryAtomContainer queryMol = null;
    private MolHandler pMol = null;
    private IAtomContainer pAC = null;
    private List<Double> stereoScore = null;
    private List<Integer> fragmentSize = null;
    private List<Double> bEnergies = null;
    private final Algorithm algorithmType;
    private boolean removeHydrogen = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Isomorphism.class);
    private double bondSensitiveTimeOut = 0.15;
    private double bondInSensitiveTimeOut = 1.0;
    private boolean subGraph = false;
    private boolean matchBonds = false;

    public Isomorphism(Algorithm algorithmType, boolean bondTypeFlag) {
        this.algorithmType = algorithmType;
        this.firstSolution = new TreeMap<Integer, Integer>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
        this.firstAtomMCS = new HashMap<IAtom, IAtom>();
        this.allBondMCS = new ArrayList<Map<IBond, IBond>>();
        this.firstBondMCS = new HashMap<IBond, IBond>();
        this.setTime(bondTypeFlag);
        this.setMatchBonds(bondTypeFlag);
    }

    private synchronized void mcsBuilder(MolHandler mol1, MolHandler mol2) {
        int rBondCount = mol1.getMolecule().getBondCount();
        int pBondCount = mol2.getMolecule().getBondCount();
        int rAtomCount = mol1.getMolecule().getAtomCount();
        int pAtomCount = mol2.getMolecule().getAtomCount();
        if (rBondCount == 0 && rAtomCount > 0 || pBondCount == 0 && pAtomCount > 0) {
            this.singleMapping();
        } else {
            this.chooseAlgorithm(rBondCount, pBondCount);
        }
        if (!this.allAtomMCS.isEmpty() && !this.firstAtomMCS.isEmpty() && this.firstAtomMCS.size() > 1) {
            this.setAllBondMaps(Isomorphism.makeBondMapsOfAtomMaps(mol1.getMolecule(), mol2.getMolecule(), this.allAtomMCS));
            if (this.getAllBondMaps().iterator().hasNext()) {
                this.setFirstBondMap(this.getAllBondMaps().iterator().next());
            }
        }
    }

    private synchronized void mcsBuilder(IQueryAtomContainer mol1, IAtomContainer mol2) {
        int rBondCount = mol1.getBondCount();
        int pBondCount = mol2.getBondCount();
        int rAtomCount = mol1.getAtomCount();
        int pAtomCount = mol2.getAtomCount();
        if (rBondCount == 0 && rAtomCount > 0 || pBondCount == 0 && pAtomCount > 0) {
            this.singleMapping();
        } else {
            this.chooseAlgorithm(rBondCount, pBondCount);
        }
        if (!this.allAtomMCS.isEmpty() && !this.firstAtomMCS.isEmpty() && this.firstAtomMCS.size() > 1) {
            this.setAllBondMaps(Isomorphism.makeBondMapsOfAtomMaps((IAtomContainer)mol1, mol2, this.allAtomMCS));
            if (this.getAllBondMaps().iterator().hasNext()) {
                this.setFirstBondMap(this.getAllBondMaps().iterator().next());
            }
        }
    }

    public static List<Map<IBond, IBond>> makeBondMapsOfAtomMaps(IAtomContainer ac1, IAtomContainer ac2, List<Map<IAtom, IAtom>> mappings) {
        ArrayList<Map<IBond, IBond>> bondMaps = new ArrayList<Map<IBond, IBond>>();
        for (Map<IAtom, IAtom> mapping : mappings) {
            bondMaps.add(Isomorphism.makeBondMapOfAtomMap(ac1, ac2, mapping));
        }
        return bondMaps;
    }

    public static Map<IBond, IBond> makeBondMapOfAtomMap(IAtomContainer ac1, IAtomContainer ac2, Map<IAtom, IAtom> mapping) {
        HashMap<IBond, IBond> maps = new HashMap<IBond, IBond>();
        for (Map.Entry<IAtom, IAtom> mapS : mapping.entrySet()) {
            IAtom indexI = mapS.getKey();
            IAtom indexJ = mapS.getValue();
            for (Map.Entry<IAtom, IAtom> mapD : mapping.entrySet()) {
                IBond ac2Bond;
                IBond ac1Bond;
                IAtom indexIPlus = mapD.getKey();
                IAtom indexJPlus = mapD.getValue();
                if (indexI.equals((Object)indexIPlus) || indexJ.equals((Object)indexJPlus) || (ac1Bond = ac1.getBond(indexI, indexIPlus)) == null || (ac2Bond = ac2.getBond(indexJ, indexJPlus)) == null) continue;
                maps.put(ac1Bond, ac2Bond);
            }
        }
        return maps;
    }

    private void chooseAlgorithm(int rBondCount, int pBondCount) {
        switch (this.algorithmType) {
            case CDKMCS: {
                this.cdkMCSAlgorithm();
                break;
            }
            case DEFAULT: {
                this.defaultMCSAlgorithm();
                break;
            }
            case MCSPlus: {
                this.mcsPlusAlgorithm();
                break;
            }
            case SubStructure: {
                this.subStructureAlgorithm(rBondCount, pBondCount);
                break;
            }
            case VFLibMCS: {
                this.vfLibMCSAlgorithm();
                break;
            }
            case TurboSubStructure: {
                this.turboSubStructureAlgorithm(rBondCount, pBondCount);
            }
        }
    }

    private synchronized void cdkMCSAlgorithm() {
        CDKMCSHandler mcs = new CDKMCSHandler();
        if (this.queryMol == null) {
            mcs.set(this.rMol, this.pMol);
        } else {
            mcs.set(this.queryMol, this.pAC);
        }
        mcs.searchMCS(this.isMatchBonds());
        this.clearMaps();
        this.firstSolution.putAll(mcs.getFirstMapping());
        this.allMCS.addAll(mcs.getAllMapping());
        this.firstAtomMCS.putAll(mcs.getFirstAtomMapping());
        this.allAtomMCS.addAll(mcs.getAllAtomMapping());
    }

    private synchronized void cdkSubgraphAlgorithm() {
        CDKSubGraphHandler mcs = new CDKSubGraphHandler();
        if (this.queryMol == null) {
            mcs.set(this.rMol, this.pMol);
        } else {
            mcs.set(this.queryMol, this.pAC);
        }
        this.clearMaps();
        if (mcs.isSubgraph(this.isMatchBonds())) {
            this.firstSolution.putAll(mcs.getFirstMapping());
            this.allMCS.addAll(mcs.getAllMapping());
            this.firstAtomMCS.putAll(mcs.getFirstAtomMapping());
            this.allAtomMCS.addAll(mcs.getAllAtomMapping());
        }
    }

    private synchronized void mcsPlusAlgorithm() {
        MCSPlusHandler mcs = new MCSPlusHandler();
        if (this.queryMol == null) {
            mcs.set(this.rMol, this.pMol);
        } else {
            mcs.set(this.queryMol, this.pAC);
        }
        mcs.searchMCS(this.isMatchBonds());
        this.clearMaps();
        this.firstSolution.putAll(mcs.getFirstMapping());
        this.allMCS.addAll(mcs.getAllMapping());
        this.firstAtomMCS.putAll(mcs.getFirstAtomMapping());
        this.allAtomMCS.addAll(mcs.getAllAtomMapping());
    }

    private void vfLibMCS() {
        VFlibMCSHandler mcs = new VFlibMCSHandler();
        if (this.queryMol == null) {
            mcs.set(this.rMol, this.pMol);
        } else {
            mcs.set(this.queryMol, this.pAC);
        }
        mcs.searchMCS(this.isMatchBonds());
        this.clearMaps();
        this.firstSolution.putAll(mcs.getFirstMapping());
        this.allMCS.addAll(mcs.getAllMapping());
        this.firstAtomMCS.putAll(mcs.getFirstAtomMapping());
        this.allAtomMCS.addAll(mcs.getAllAtomMapping());
    }

    private void subStructureHandler() {
        VFlibSubStructureHandler subGraphTurboSearch = new VFlibSubStructureHandler();
        if (this.queryMol == null) {
            subGraphTurboSearch.set(this.rMol, this.pMol);
        } else {
            subGraphTurboSearch.set(this.queryMol, this.pAC);
        }
        this.clearMaps();
        this.subGraph = subGraphTurboSearch.isSubgraph(this.isMatchBonds());
        if (this.subGraph) {
            this.firstSolution.putAll(subGraphTurboSearch.getFirstMapping());
            this.allMCS.addAll(subGraphTurboSearch.getAllMapping());
            this.firstAtomMCS.putAll(subGraphTurboSearch.getFirstAtomMapping());
            this.allAtomMCS.addAll(subGraphTurboSearch.getAllAtomMapping());
        }
    }

    private void turboSubStructureHandler() {
        VFlibTurboHandler subGraphTurboSearch = new VFlibTurboHandler();
        if (this.queryMol == null) {
            subGraphTurboSearch.set(this.rMol, this.pMol);
        } else {
            subGraphTurboSearch.set(this.queryMol, this.pAC);
        }
        this.clearMaps();
        this.subGraph = subGraphTurboSearch.isSubgraph(this.isMatchBonds());
        if (this.subGraph) {
            this.firstSolution.putAll(subGraphTurboSearch.getFirstMapping());
            this.allMCS.addAll(subGraphTurboSearch.getAllMapping());
            this.firstAtomMCS.putAll(subGraphTurboSearch.getFirstAtomMapping());
            this.allAtomMCS.addAll(subGraphTurboSearch.getAllAtomMapping());
        }
    }

    private void singleMapping() {
        SingleMappingHandler mcs = new SingleMappingHandler(this.removeHydrogen);
        if (this.queryMol == null) {
            mcs.set(this.rMol, this.pMol);
        } else {
            mcs.set(this.queryMol, this.pAC);
        }
        mcs.searchMCS(this.isMatchBonds());
        this.clearMaps();
        this.firstSolution.putAll(mcs.getFirstMapping());
        this.allMCS.addAll(mcs.getAllMapping());
        this.firstAtomMCS.putAll(mcs.getFirstAtomMapping());
        this.allAtomMCS.addAll(mcs.getAllAtomMapping());
    }

    private int getHCount(IAtomContainer molecule) {
        int count = 0;
        for (IAtom atom : molecule.atoms()) {
            if (!atom.getSymbol().equalsIgnoreCase("H")) continue;
            ++count;
        }
        return count;
    }

    private boolean isBondMatch(IAtomContainer reactant, IAtomContainer product) {
        int counter = 0;
        Object[] ketSet = this.firstAtomMCS.keySet().toArray();
        for (int i = 0; i < ketSet.length; ++i) {
            for (int j = i + 1; j < ketSet.length; ++j) {
                IAtom indexI = (IAtom)ketSet[i];
                IAtom indexJ = (IAtom)ketSet[j];
                IBond rBond = reactant.getBond(indexI, indexJ);
                if (rBond == null) continue;
                ++counter;
            }
        }
        Object[] valueSet = this.firstAtomMCS.values().toArray();
        for (int i = 0; i < valueSet.length; ++i) {
            for (int j = i + 1; j < valueSet.length; ++j) {
                IAtom indexI = (IAtom)valueSet[i];
                IAtom indexJ = (IAtom)valueSet[j];
                IBond pBond = product.getBond(indexI, indexJ);
                if (pBond == null) continue;
                --counter;
            }
        }
        return counter == 0;
    }

    private void defaultMCSAlgorithm() {
        try {
            if (this.isMatchBonds()) {
                this.cdkMCSAlgorithm();
                if (this.getFirstMapping() == null || this.isTimeOut()) {
                    this.vfLibMCS();
                }
            } else {
                this.mcsPlusAlgorithm();
                if (this.getFirstMapping() == null || this.isTimeOut()) {
                    this.vfLibMCS();
                }
            }
        }
        catch (Exception e) {
            LoggingToolFactory.createLoggingTool(Isomorphism.class).warn((Object)"Unexpected Error:", new Object[]{e});
        }
    }

    private void subStructureAlgorithm(int rBondCount, int pBondCount) {
        try {
            if (rBondCount > 0 && pBondCount > 0) {
                this.cdkSubgraphAlgorithm();
                if (this.getFirstMapping() == null || this.isTimeOut()) {
                    this.subStructureHandler();
                }
            } else {
                this.singleMapping();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    private void turboSubStructureAlgorithm(int rBondCount, int pBondCount) {
        try {
            if (rBondCount > 0 && pBondCount > 0) {
                this.turboSubStructureHandler();
            } else {
                this.singleMapping();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    private void vfLibMCSAlgorithm() {
        this.vfLibMCS();
    }

    private void setTime(boolean bondTypeFlag) {
        if (bondTypeFlag) {
            TimeOut tmo = TimeOut.getInstance();
            tmo.setTimeOut(this.getBondSensitiveTimeOut());
        } else {
            TimeOut tmo = TimeOut.getInstance();
            tmo.setTimeOut(this.getBondInSensitiveTimeOut());
        }
    }

    public boolean isTimeOut() {
        return TimeOut.getInstance().isTimeOutFlag();
    }

    public void resetTimeOut() {
        TimeOut.getInstance().setTimeOutFlag(false);
    }

    private void clearMaps() {
        this.firstSolution.clear();
        this.allMCS.clear();
        this.allAtomMCS.clear();
        this.firstAtomMCS.clear();
    }

    private void init(MolHandler reactant, MolHandler product) throws CDKException {
        this.rMol = reactant;
        this.pMol = product;
        this.mcsBuilder(reactant, product);
    }

    @Override
    public void init(IQueryAtomContainer reactant, IAtomContainer product) throws CDKException {
        this.queryMol = reactant;
        this.pAC = product;
        this.mcsBuilder(this.queryMol, this.pAC);
    }

    @Override
    public void init(IAtomContainer reactant, IAtomContainer product, boolean removeHydrogen, boolean cleanAndConfigureMolecule) throws CDKException {
        this.removeHydrogen = removeHydrogen;
        this.init(new MolHandler(reactant, removeHydrogen, cleanAndConfigureMolecule), new MolHandler(product, removeHydrogen, cleanAndConfigureMolecule));
    }

    public void init(String sourceMolFileName, String targetMolFileName, boolean removeHydrogen, boolean cleanAndConfigureMolecule) throws CDKException {
        this.removeHydrogen = removeHydrogen;
        this.init(new MolHandler(sourceMolFileName, cleanAndConfigureMolecule, removeHydrogen), new MolHandler(targetMolFileName, cleanAndConfigureMolecule, removeHydrogen));
    }

    @Override
    public void setChemFilters(boolean stereoFilter, boolean fragmentFilter, boolean energyFilter) {
        if (this.firstAtomMCS != null) {
            ChemicalFilters chemFilter = new ChemicalFilters(this.allMCS, this.allAtomMCS, this.firstSolution, this.firstAtomMCS, this.getReactantMolecule(), this.getProductMolecule());
            if (stereoFilter && this.firstAtomMCS.size() > 1) {
                try {
                    chemFilter.sortResultsByStereoAndBondMatch();
                    this.stereoScore = chemFilter.getStereoMatches();
                }
                catch (CDKException ex) {
                    LOGGER.error((Object)Level.SEVERE, new Object[]{null, ex});
                }
            }
            if (fragmentFilter) {
                chemFilter.sortResultsByFragments();
                this.fragmentSize = chemFilter.getSortedFragment();
            }
            if (energyFilter) {
                try {
                    chemFilter.sortResultsByEnergies();
                    this.bEnergies = chemFilter.getSortedEnergy();
                }
                catch (CDKException ex) {
                    LOGGER.error((Object)Level.SEVERE, new Object[]{null, ex});
                }
            }
        }
    }

    @Override
    public synchronized Integer getFragmentSize(int key) {
        return this.fragmentSize != null && !this.fragmentSize.isEmpty() ? this.fragmentSize.get(key) : null;
    }

    @Override
    public synchronized Integer getStereoScore(int key) {
        return this.stereoScore != null && !this.stereoScore.isEmpty() ? Integer.valueOf(this.stereoScore.get(key).intValue()) : null;
    }

    @Override
    public synchronized Double getEnergyScore(int key) {
        return this.bEnergies != null && !this.bEnergies.isEmpty() ? this.bEnergies.get(key) : null;
    }

    @Override
    public synchronized Map<Integer, Integer> getFirstMapping() {
        return this.firstSolution.isEmpty() ? null : this.firstSolution;
    }

    @Override
    public synchronized List<Map<Integer, Integer>> getAllMapping() {
        return this.allMCS.isEmpty() ? null : this.allMCS;
    }

    @Override
    public synchronized Map<IAtom, IAtom> getFirstAtomMapping() {
        return this.firstAtomMCS.isEmpty() ? null : this.firstAtomMCS;
    }

    @Override
    public synchronized List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return this.allAtomMCS.isEmpty() ? null : this.allAtomMCS;
    }

    @Override
    public IAtomContainer getReactantMolecule() {
        return this.queryMol == null ? this.rMol.getMolecule() : this.queryMol;
    }

    @Override
    public IAtomContainer getProductMolecule() {
        return this.pAC == null ? this.pMol.getMolecule() : this.pAC;
    }

    @Override
    public double getTanimotoSimilarity() throws IOException {
        double tanimoto = this.getTanimotoAtomSimilarity() + this.getTanimotoBondSimilarity();
        if (tanimoto > 0.0 && this.getReactantMolecule().getBondCount() > 0 && this.getProductMolecule().getBondCount() > 0) {
            tanimoto /= 2.0;
        }
        return tanimoto;
    }

    public double getTanimotoAtomSimilarity() throws IOException {
        int decimalPlaces = 4;
        double tanimotoAtom = 0.0;
        Map<Integer, Integer> firstMapping = this.getFirstMapping();
        if (firstMapping != null && !firstMapping.isEmpty()) {
            int pAtomCount;
            int rAtomCount;
            if (!this.removeHydrogen) {
                rAtomCount = this.getReactantMolecule().getAtomCount();
                pAtomCount = this.getProductMolecule().getAtomCount();
            } else {
                rAtomCount = this.getReactantMolecule().getAtomCount() - this.getHCount(this.getReactantMolecule());
                pAtomCount = this.getProductMolecule().getAtomCount() - this.getHCount(this.getProductMolecule());
            }
            double matchCount = firstMapping.size();
            tanimotoAtom = matchCount / ((double)(rAtomCount + pAtomCount) - matchCount);
            BigDecimal tan = BigDecimal.valueOf(tanimotoAtom);
            tan = tan.setScale(decimalPlaces, RoundingMode.HALF_UP);
            tanimotoAtom = tan.doubleValue();
        }
        return tanimotoAtom;
    }

    public double getTanimotoBondSimilarity() throws IOException {
        int decimalPlaces = 4;
        double tanimotoAtom = 0.0;
        if (this.getFirstBondMap() != null && !this.getFirstBondMap().isEmpty()) {
            int rBondCount = this.getReactantMolecule().getBondCount();
            int pBondCount = this.getProductMolecule().getBondCount();
            double matchCount = this.getFirstBondMap().size();
            tanimotoAtom = matchCount / ((double)(rBondCount + pBondCount) - matchCount);
            BigDecimal tan = BigDecimal.valueOf(tanimotoAtom);
            tan = tan.setScale(decimalPlaces, RoundingMode.HALF_UP);
            tanimotoAtom = tan.doubleValue();
        }
        return tanimotoAtom;
    }

    @Override
    public boolean isStereoMisMatch() {
        boolean flag = false;
        IAtomContainer reactant = this.getReactantMolecule();
        IAtomContainer product = this.getProductMolecule();
        int score = 0;
        for (Map.Entry<IAtom, IAtom> mappingI : this.firstAtomMCS.entrySet()) {
            IAtom indexI = mappingI.getKey();
            IAtom indexJ = mappingI.getValue();
            for (Map.Entry<IAtom, IAtom> mappingJ : this.firstAtomMCS.entrySet()) {
                IAtom indexIPlus = mappingJ.getKey();
                IAtom indexJPlus = mappingJ.getValue();
                if (indexI.equals((Object)indexIPlus) || indexJ.equals((Object)indexJPlus)) continue;
                IAtom sourceAtom1 = indexI;
                IAtom sourceAtom2 = indexIPlus;
                IBond rBond = reactant.getBond(sourceAtom1, sourceAtom2);
                IAtom targetAtom1 = indexJ;
                IAtom targetAtom2 = indexJPlus;
                IBond pBond = product.getBond(targetAtom1, targetAtom2);
                if (rBond == null || pBond == null || rBond.getStereo() == pBond.getStereo()) continue;
                ++score;
            }
        }
        if (score > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean isSubgraph() {
        IAtomContainer reactant = this.getReactantMolecule();
        IAtomContainer product = this.getProductMolecule();
        if (this.firstSolution == null || this.firstSolution.isEmpty()) {
            return false;
        }
        float mappingSize = this.firstSolution.size();
        int sourceAtomCount = reactant.getAtomCount();
        int targetAtomCount = product.getAtomCount();
        if (this.removeHydrogen) {
            sourceAtomCount -= this.getHCount(reactant);
            targetAtomCount -= this.getHCount(product);
        }
        if (mappingSize == (float)sourceAtomCount && mappingSize <= (float)targetAtomCount) {
            if (!this.getFirstBondMap().isEmpty() && this.getFirstBondMap().size() == reactant.getBondCount()) {
                return true;
            }
            if (mappingSize == 1.0f) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double getEuclideanDistance() throws IOException {
        int decimalPlaces = 4;
        double euclidean = -1.0;
        Map<Integer, Integer> firstMapping = this.getFirstMapping();
        if (firstMapping != null && !firstMapping.isEmpty()) {
            double target;
            double source;
            if (!this.removeHydrogen) {
                source = this.getReactantMolecule().getAtomCount();
                target = this.getProductMolecule().getAtomCount();
            } else {
                source = (double)this.getReactantMolecule().getAtomCount() - (double)this.getHCount(this.getReactantMolecule());
                target = (double)this.getProductMolecule().getAtomCount() - (double)this.getHCount(this.getProductMolecule());
            }
            double common = firstMapping.size();
            euclidean = Math.sqrt(source + target - 2.0 * common);
            BigDecimal dist = BigDecimal.valueOf(euclidean);
            dist = dist.setScale(decimalPlaces, RoundingMode.HALF_UP);
            euclidean = dist.doubleValue();
        }
        return euclidean;
    }

    @Override
    public double getBondSensitiveTimeOut() {
        return this.bondSensitiveTimeOut;
    }

    @Override
    public void setBondSensitiveTimeOut(double bondSensitiveTimeOut) {
        this.bondSensitiveTimeOut = bondSensitiveTimeOut;
    }

    @Override
    public double getBondInSensitiveTimeOut() {
        return this.bondInSensitiveTimeOut;
    }

    @Override
    public void setBondInSensitiveTimeOut(double bondInSensitiveTimeOut) {
        this.bondInSensitiveTimeOut = bondInSensitiveTimeOut;
    }

    public boolean isMatchBonds() {
        return this.matchBonds;
    }

    public void setMatchBonds(boolean matchBonds) {
        this.matchBonds = matchBonds;
    }

    public List<Map<IBond, IBond>> getAllBondMaps() {
        return this.allBondMCS;
    }

    private void setAllBondMaps(List<Map<IBond, IBond>> allBondMCS) {
        this.allBondMCS = allBondMCS;
    }

    public Map<IBond, IBond> getFirstBondMap() {
        return this.firstBondMCS;
    }

    private void setFirstBondMap(Map<IBond, IBond> firstBondMCS) {
        this.firstBondMCS = firstBondMCS;
    }
}

