% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.r
\name{publish}
\alias{publish}
\title{Render your challenge R Markdown script to a HTML page.}
\usage{
publish(
  input = "challenge.rmd",
  output_file = "index.html",
  output_dir = dirname(input),
  quiet = FALSE,
  ...
)
}
\arguments{
\item{input}{string. name of the R Markdown input file}

\item{output_file}{string. output file. If \code{NULL} then a default based on the name 
of the input file is chosen.}

\item{output_dir}{string. output directory. Defaults to the directory of the input file.
make sure that the output HTML file will be published online.}

\item{quiet}{logical. deactivate text output.}

\item{...}{further arguments to pass to \code{\link[rmarkdown]{render}}.}
}
\value{
The compiled document is written into the output file, and the path 
  of the output file is returned.
}
\description{
Render your challenge R Markdown script to a HTML page.
}
\note{
The rendering of HTML content provided by Dropbox will be discontinued 
from the 3rd October 2016 for Basic users and the 1st September 2017 for Pro 
and Business users. See \url{https://www.dropbox.com/help/16}. Alternatively, 
\href{https://pages.github.com/}{GitHub Pages} provide an easy HTML web publishing 
solution via a simple GitHub repository.
}
\examples{
path <- tempdir()
wd <- setwd(path)
new_challenge()
outdir = tempdir()
publish(output_dir = outdir, output_options = list(self_contained = FALSE))
unlink(outdir)
setwd(wd)
unlink(path)
}
\seealso{
\code{\link[rmarkdown]{render}}
}
