% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_name_match.R
\name{cp_name_match}
\alias{cp_name_match}
\title{Name Matching}
\usage{
cp_name_match(
  q = NULL,
  rank = NULL,
  code = NULL,
  trusted = NULL,
  ver_bose = NULL,
  start = 0,
  limit = 10,
  ...
)
}
\arguments{
\item{q}{(character) scientific name to match}

\item{rank}{(character) rank to restrict matches to. one of: domain,
realm, subrealm, superkingdom, kingdom, subkingdom, infrakingdom,
superphylum, phylum, subphylum, infraphylum, superclass, class,
subclass, infraclass, parvclass, superdivision, division, subdivision,
infradivision, superlegion, legion, sublegion, infralegion, supercohort,
cohort, subcohort, infracohort, gigaorder, magnorder, grandorder, mirorder,
superorder, order, nanorder, hypoorder, minorder, suborder, infraorder,
parvorder, megafamily, grandfamily, superfamily, epifamily, family,
subfamily, infrafamily, supertribe, tribe, subtribe, infratribe,
suprageneric_name, genus, subgenus, infragenus, supersection, section,
subsection, superseries, series, subseries, infrageneric_name,
species_aggregate, species, infraspecific_name, grex, subspecies,
cultivar_group, convariety, infrasubspecific_name, proles, natio,
aberration, morph, variety, subvariety, form, subform, pathovar, biovar,
chemovar, morphovar, phagovar, serovar, chemoform, forma_specialis,
cultivar, strain, other, unranked}

\item{code}{(character) nomenclatural code to restrict matches to. one of:
bacterial, botanical, cultivars, viral, zoological, phytosociological}

\item{trusted}{(logical) if \code{TRUE}, unmatched name will be inserted into
the names index. default: \code{FALSE}}

\item{ver_bose}{(logical) if \code{TRUE}, list alternatively considered name
matches. default: \code{FALSE}}

\item{start}{(integer) requested number of offset records. Default: 0}

\item{limit}{(integer) requested number of maximum records to be returned.
Default: 10; max: 1000}

\item{...}{curl options passed on to \code{\link[crul]{verb-GET}}}
}
\value{
a named list, with slots \code{name} (list), \code{type} (character),
\code{alternatives} (data.frame), and \code{nameKey} (integer)
}
\description{
Match name against the name index
}
\details{
Matches by the canonical name, it's authorship and rank.
Authorship matching is somewhat loose, but name matching is quite strict
and only allows for a few common misspellings frequently found in
epithets (silent h, gender suffix, double letters, i/y), but not in
uninomials. Suprageneric ranks are all considered to be the same,
otherwise a different rank results in a different match.
}
\examples{
if (cp_up("/name/matching?q=Apis")) { 
cp_name_match(q="Apis")
}
\dontrun{
cp_name_match(q="Agapostemon")
cp_name_match(q="Apis mellifera")
cp_name_match(q="Apis mellifer") # no fuzzy match apparently
}
}
