% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_datasets.R
\name{cp_datasets}
\alias{cp_datasets}
\alias{cp_dataset}
\title{Datasets}
\usage{
cp_datasets(q = NULL, start = 0, limit = 10, ...)

cp_dataset(dataset_keys, ...)
}
\arguments{
\item{q}{(character) main query string. optional}

\item{start}{(integer) requested number of offset records. Default: 0}

\item{limit}{(integer) requested number of maximum records to be returned.
Default: 10; max: 1000}

\item{...}{curl options passed on to \code{\link[crul]{verb-GET}}}

\item{dataset_keys}{(character) one or more dataset keys. required}
}
\value{
list with two slots
\itemize{
\item \code{result} (data.frame/tibble): results, a zero row data.frame
if no results found
\item \code{meta} (data.frame/tibble): number of results found
}
}
\description{
Datasets
}
\details{
for \code{cp_dataset()}, separate http requests are made for each
dataset key. unfortunately, the output of \code{cp_dataset()} is a list for
each dataset key because the nested structure of the data is hard to
rectangularize
}
\examples{
if (cp_up("/dataset")) {
cp_datasets(limit = 1)
}
\dontrun{
cp_datasets(q = "life")
cp_dataset(dataset_keys = 1000)
cp_dataset(dataset_keys = c(3, 1000, 1014))
}
}
