% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nominalSymmetryTest.r
\name{nominalSymmetryTest}
\alias{nominalSymmetryTest}
\title{Exact and Monte Carlo symmetry tests for paired contigency tables}
\usage{
nominalSymmetryTest(x, method = "fdr", digits = 3, ...)
}
\arguments{
\item{x}{A two-way contingency table. It must be square. 
It can have two or
more levels for each dimension.}

\item{method}{The method to adjust multiple p-values. 
See \code{\link{p.adjust}}.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments, passed to \code{\link{multinomial.test}}.}
}
\value{
A list containing: a data frame of results of the global test;
        a data frame of results of the pairwise results;
        and a data frame mentioning the p-value adjustment method.
}
\description{
Conducts an omnibus symmetry test for a paired 
             contingency table and then post-hoc pairwise tests.  
             This is similar to  
             McNemar and McNemar-Bowker tests in use.
}
\details{
If Monte Carlo is not used, the test of symmetry uses
         an exact test by conducting either a binomial 
         or multinomial goodness-of-fit test.
         
         These are equivalent to uncorrected 
         McNemar and McNemar-Bowker tests,
         but will not fail when there are zeros in critical
         cells, as will the \code{mcnemar.test} function.
}
\examples{
### 2 x 2 repeated matrix example
data(AndersonRainBarrel)
nominalSymmetryTest(AndersonRainBarrel)
                    
### 3 x 3 repeated matrix example with Monte Carlo
data(AndersonRainGarden)
nominalSymmetryTest(AndersonRainGarden,
                    MonteCarlo = TRUE,
                    ntrial     = 10000)
                    
### 4 x 4 repeated matrix example that fails with mcnemar.test
data(Religion)
nominalSymmetryTest(Religion,
                    MonteCarlo = TRUE,
                    ntrial     = 10000)
                                                              
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/H_05.html}
}
\seealso{
\code{\link{pairwiseMcnemar}}, \code{\link{groupwiseCMH}},
         \code{\link{pairwiseNominalIndependence}}, 
         \code{\link{pairwiseNominalMatrix}}
}
\concept{
McNemar Bowker contingency table symmetry nominal
}

