% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNormalHistogram.r
\name{plotNormalHistogram}
\alias{plotNormalHistogram}
\title{Histogram with a normal curve}
\usage{
plotNormalHistogram(x, prob = FALSE, col = "gray", main = "",
  linecol = "blue", lwd = 2, length = 1000, ...)
}
\arguments{
\item{x}{A vector of values.}

\item{prob}{If \code{FALSE}, then counts are displayed in the histogram.
If \code{TRUE}, then the density is shown.}

\item{col}{The color of the histogram bars.}

\item{main}{The title displayed for the plot.}

\item{linecol}{The color of the line in the plot.}

\item{lwd}{The width of the line in the plot.}

\item{length}{The number of points in the line in the plot.}

\item{...}{Other arguments passed to \code{\link{hist}}.}
}
\value{
Produces a plot. Returns nothing.
}
\description{
Produces a histogram for a vector of values and adds a normal
             curve with the same mean and standard deviation. The plot
             can be used to quickly compare the distribution of data
             to a normal distribution.
}
\details{
The function relies on the \code{hist} function. The normal curve
          has the same mean and standard deviation as the values in the
          vector.
}
\examples{
### Plot of residuals from a model fit with lm
data(Catbus)
model = lm(Steps ~ Sex + Teacher,
           data = Catbus)
 plotNormalHistogram(residuals(model))          

}
\references{
\url{http://rcompanion.org/handbook/I_01.html}
}
\seealso{
\code{\link{plotNormalDensity}} \code{\link{plotDensityHistogram}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
normal distribution histogram
}
