% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_dedup.R
\name{core_articles_dedup}
\alias{core_articles_dedup}
\alias{core_articles_dedup_}
\title{Article deduplication}
\usage{
core_articles_dedup(
  doi = NULL,
  title = NULL,
  year = NULL,
  description = NULL,
  fulltext = NULL,
  identifier = NULL,
  repositoryId = NULL,
  key = NULL,
  parse = TRUE,
  ...
)

core_articles_dedup_(
  doi = NULL,
  title = NULL,
  year = NULL,
  description = NULL,
  fulltext = NULL,
  identifier = NULL,
  repositoryId = NULL,
  key = NULL,
  ...
)
}
\arguments{
\item{doi}{(character) the DOI for which the duplicates will be identified.
optional}

\item{title}{(character) title to match when looking for duplicate articles.
Either \code{year} or \code{description} should also be supplied if this parameter is
supplied. optional}

\item{year}{(character) year the article was published. Only used in
combination with the value for \code{title} parameter. optional}

\item{description}{(character) abstract for an article based on which its
duplicates will be found. This should be more than 500 characters. Value
for the \code{title} parameter should also be supplied if this is supplied.
optional}

\item{fulltext}{(character) Full text for an article based on which its
duplicates will be found. optional}

\item{identifier}{(character) CORE ID of the article for which the
duplicates will be identified. optional}

\item{repositoryId}{(character) Limit the duplicates search to
particular repository id. optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Article deduplication
}
\examples{
\dontrun{
core_articles_dedup(title = "Managing exploratory innovation", year = 2010)
core_articles_dedup_(title = "Managing exploratory innovation", year = 2010)

ab = 'Neonicotinoid seed dressings have caused concern world-wide. We use
large field experiments to assess the effects of neonicotinoid-treated crops
on three bee species across three countries (Hungary, Germany, and the
United Kingdom). Winter-sown oilseed rape was grown commercially with
either seed coatings containing neonicotinoids (clothianidin or
thiamethoxam) or no seed treatment (control). For honey bees, we found
both negative (Hungary and United Kingdom) and positive (Germany)
effects during crop flowering. In Hungary, negative effects on honey
bees (associated with clothianidin) persisted over winter and resulted
in smaller colonies in the following spring (24\% declines). In wild
bees (Bombus terrestris and Osmia bicornis), reproduction was
negatively correlated with neonicotinoid residues. These findings
point to neonicotinoids causing a reduced capacity of bee species
to establish new populations in the year following exposure.'
core_articles_dedup(
  title = "Country-specific effects of neonicotinoid pesticides on honey bees and wild bees",
  description = ab, verbose = TRUE)
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/nearDuplicateArticles}
}
