% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_journals.R, R/core_repos.R
\name{core_journals}
\alias{core_journals}
\alias{core_journals_}
\alias{core_repos_}
\title{Get journal via its ISSN}
\usage{
core_journals(id, key = NULL, method = "GET", parse = TRUE, ...)

core_journals_(id, key = NULL, method = "GET", ...)

core_repos_(id, key = NULL, method = "GET", ...)
}
\arguments{
\item{id}{(integer) One or more journal ISSNs. Required}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{method}{(character) one of 'GET' (default) or 'POST'}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Get journal via its ISSN
}
\details{
\code{core_journals} does the HTTP request and parses, while
\code{core_journals_} just does the HTTP request, gives back JSON as a
character string

These functions take one article ID at a time. Use lapply/loops/etc for
many ids
}
\examples{
\dontrun{
core_journals(id = '2167-8359')

ids <- c("2167-8359", "2050-084X")
res <- lapply(ids, core_journals)
vapply(res, "[[", "", c("data", "title"))

# just http request, get text back
core_journals_('2167-8359')

# post request, ideal for lots of ISSNs
if (requireNamespace("rcrossref", quietly = TRUE)) {
 library(rcrossref)
 res <- lapply(c("bmc", "peerj", "elife", "plos", "frontiers"), function(z)
    cr_journals(query = z))
 ids <- na.omit(unlist(lapply(res, function(b) b$data$issn)))
 out <- core_journals(ids, method = "POST")
 head(out)
}

}
}
\references{
\url{https://core.ac.uk/docs/#!/journals/getJournalByIssnBatch}
\url{https://core.ac.uk/docs/#!/journals/getJournalByIssn}
}
